/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.collection.dictionary;

import com.github.liblevenshtein.collection.AbstractIterator;
import com.github.liblevenshtein.collection.dictionary.DawgNode;
import com.github.liblevenshtein.collection.dictionary.IFinalFunction;
import com.github.liblevenshtein.collection.dictionary.Prefix;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.util.ArrayDeque;
import java.util.Queue;
import lombok.NonNull;

public class DawgIterator
extends AbstractIterator<String> {
    private static final long serialVersionUID = 1L;
    private final Queue<Prefix> prefixes = new ArrayDeque<Prefix>();
    private final IFinalFunction<DawgNode> isFinal;

    public DawgIterator(@NonNull DawgNode root, @NonNull IFinalFunction<DawgNode> isFinal) {
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        if (isFinal == null) {
            throw new IllegalArgumentException("isFinal is null");
        }
        this.isFinal = isFinal;
        this.prefixes.offer(new Prefix(root));
    }

    @Override
    protected void advance() {
        if (null == this.next && !this.prefixes.isEmpty()) {
            String value;
            DawgNode node;
            do {
                Prefix prefix = this.prefixes.poll();
                node = prefix.node();
                value = prefix.value();
                CharIterator iter = node.labels();
                while (iter.hasNext()) {
                    char label = iter.nextChar();
                    DawgNode nextNode = node.transition(label);
                    this.prefixes.add(new Prefix(nextNode, prefix, label));
                }
            } while (!this.isFinal.at(node));
            this.next = value;
        }
    }
}

