/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.collection.dictionary;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DawgNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    protected final Char2ObjectMap<DawgNode> edges;

    public DawgNode() {
        this((Char2ObjectMap<DawgNode>)new Char2ObjectRBTreeMap());
    }

    public boolean isFinal() {
        return false;
    }

    public CharIterator labels() {
        return this.edges.keySet().iterator();
    }

    public DawgNode transition(char label) {
        return (DawgNode)this.edges.get(label);
    }

    public DawgNode addEdge(char label, DawgNode target) {
        this.edges.put(label, (Object)target);
        return this;
    }

    public void clear() {
        this.edges.clear();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DawgNode)) {
            return false;
        }
        DawgNode other = (DawgNode)object;
        return new EqualsBuilder().append(this.edges, other.edges).append(this.isFinal(), other.isFinal()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(419, 181).append(this.edges).append(this.isFinal()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("edges", this.edges).append("isFinal", this.isFinal()).toString();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public Char2ObjectMap<DawgNode> edges() {
        return this.edges;
    }

    @ConstructorProperties(value={"edges"})
    @SuppressFBWarnings(justification="generated code")
    public DawgNode(@NonNull Char2ObjectMap<DawgNode> edges) {
        if (edges == null) {
            throw new IllegalArgumentException("edges is null");
        }
        this.edges = edges;
    }
}

