/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.collection.dictionary;

import com.github.liblevenshtein.collection.dictionary.Dawg;
import com.github.liblevenshtein.collection.dictionary.DawgNode;
import com.github.liblevenshtein.collection.dictionary.FinalDawgNode;
import com.github.liblevenshtein.collection.dictionary.Transition;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class SortedDawg
extends Dawg {
    private static final long serialVersionUID = 1L;
    private Deque<Transition> uncheckedTransitions = new ArrayDeque<Transition>();
    private Map<DawgNode, DawgNode> minimizedNodes = new HashMap<DawgNode, DawgNode>();
    private String previousTerm = "";

    public SortedDawg() {
    }

    public SortedDawg(@NonNull Collection<String> terms) {
        this();
        if (terms == null) {
            throw new IllegalArgumentException("terms is null");
        }
        if (!this.addAll((Collection<? extends String>)terms)) {
            throw new IllegalStateException("Failed to add all terms");
        }
        this.finish();
    }

    public SortedDawg(int size, @NonNull DawgNode root) {
        super(root, size);
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
    }

    @Override
    public synchronized boolean add(@NonNull String term) {
        int i;
        if (term == null) {
            throw new IllegalArgumentException("term is null");
        }
        if (term.compareTo(this.previousTerm) < 0) {
            throw new IllegalArgumentException("Due to caveats with the current DAWG implementation, terms must be inserted in ascending order");
        }
        if (term.isEmpty()) {
            this.root = new FinalDawgNode();
            return true;
        }
        int upperBound = term.length() < this.previousTerm.length() ? term.length() : this.previousTerm.length();
        for (i = 0; i < upperBound && term.charAt(i) == this.previousTerm.charAt(i); ++i) {
        }
        this.minimize(i);
        DawgNode node = null == this.uncheckedTransitions.peekFirst() ? this.root : this.uncheckedTransitions.peekFirst().target();
        int k = term.length() - 1;
        while (i < k) {
            char label = term.charAt(i);
            DawgNode nextNode = new DawgNode();
            this.uncheckedTransitions.addFirst(new Transition(node, label, nextNode));
            node = nextNode;
            ++i;
        }
        if (i < term.length()) {
            char label = term.charAt(i);
            FinalDawgNode nextNode = new FinalDawgNode();
            this.uncheckedTransitions.addFirst(new Transition(node, label, nextNode));
        }
        this.previousTerm = term;
        ++this.size;
        return true;
    }

    public void finish() {
        this.minimize(0);
    }

    private void minimize(int lowerBound) {
        for (int j = this.uncheckedTransitions.size(); j > lowerBound; --j) {
            Transition transition = this.uncheckedTransitions.removeFirst();
            DawgNode source = transition.source();
            char label = transition.label();
            DawgNode target = transition.target();
            DawgNode existing = this.minimizedNodes.get(target);
            if (null != existing) {
                source.addEdge(label, existing);
                continue;
            }
            source.addEdge(label, target);
            this.minimizedNodes.put(target, target);
        }
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("SortedDawg does not support removing terms");
    }
}

