/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.collection.dictionary.factory;

import com.github.liblevenshtein.collection.dictionary.Dawg;
import com.github.liblevenshtein.collection.dictionary.DawgNode;
import com.github.liblevenshtein.collection.dictionary.IFinalFunction;
import com.github.liblevenshtein.collection.dictionary.ITransitionFunction;
import com.github.liblevenshtein.collection.dictionary.SortedDawg;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DawgFactory
implements Serializable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(DawgFactory.class);
    private static final long serialVersionUID = 1L;

    public Dawg build(@NonNull Collection<String> terms) {
        if (terms == null) {
            throw new IllegalArgumentException("terms is null");
        }
        return this.build(terms, false);
    }

    public Dawg build(@NonNull Collection<String> terms, boolean isSorted) {
        if (terms == null) {
            throw new IllegalArgumentException("terms is null");
        }
        if (terms instanceof SortedDawg) {
            return (SortedDawg)terms;
        }
        if (!isSorted) {
            if (!(terms instanceof List)) {
                return this.build(new ArrayList<String>(terms), false);
            }
            Collections.sort((List)terms);
        }
        return new SortedDawg(terms);
    }

    public IFinalFunction<DawgNode> finalFunction(@NonNull Dawg dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary is null");
        }
        return dictionary;
    }

    public ITransitionFunction<DawgNode> transitionFunction(@NonNull Dawg dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary is null");
        }
        return dictionary;
    }
}

