/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.distance;

import com.github.liblevenshtein.collection.SymmetricImmutablePair;
import com.github.liblevenshtein.distance.AbstractMemoized;

public class MemoizedStandard
extends AbstractMemoized {
    private static final long serialVersionUID = 1L;

    @Override
    public int memoizedDistance(String v, String w) {
        SymmetricImmutablePair<String> key = new SymmetricImmutablePair<String>(v, w);
        int distance = this.memo.getInt(key);
        if (distance != -1) {
            return distance;
        }
        if (v.isEmpty()) {
            distance = w.length();
            this.memo.put(key, distance);
            return distance;
        }
        if (w.isEmpty()) {
            distance = v.length();
            this.memo.put(key, distance);
            return distance;
        }
        char a = v.charAt(0);
        String s = v.substring(1);
        char b = w.charAt(0);
        String t = w.substring(1);
        while (a == b && s.length() > 0 && t.length() > 0) {
            a = s.charAt(0);
            v = s;
            s = v.substring(1);
            b = t.charAt(0);
            w = t;
            t = w.substring(1);
        }
        if (a == b) {
            distance = s.isEmpty() ? t.length() : s.length();
            this.memo.put(key, distance);
            return distance;
        }
        distance = this.memoizedDistance(s, w);
        if (0 == distance) {
            this.memo.put(key, 1);
            return 1;
        }
        int minDistance = distance;
        distance = this.memoizedDistance(v, t);
        if (0 == distance) {
            this.memo.put(key, 1);
            return 1;
        }
        if (distance < minDistance) {
            minDistance = distance;
        }
        if (0 == (distance = this.memoizedDistance(s, t))) {
            this.memo.put(key, 1);
            return 1;
        }
        if (distance < minDistance) {
            minDistance = distance;
        }
        distance = 1 + minDistance;
        this.memo.put(key, distance);
        return distance;
    }
}

