/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.distance;

import com.github.liblevenshtein.collection.SymmetricImmutablePair;
import com.github.liblevenshtein.distance.AbstractMemoized;

public class MemoizedTransposition
extends AbstractMemoized {
    private static final long serialVersionUID = 1L;

    @Override
    public int memoizedDistance(String v, String w) {
        SymmetricImmutablePair<String> key = new SymmetricImmutablePair<String>(v, w);
        int distance = this.memo.getInt(key);
        if (distance != -1) {
            return distance;
        }
        if (v.isEmpty()) {
            distance = w.length();
            this.memo.put(key, distance);
            return distance;
        }
        if (w.isEmpty()) {
            distance = v.length();
            this.memo.put(key, distance);
            return distance;
        }
        char a = v.charAt(0);
        String x = v.substring(1);
        char b = w.charAt(0);
        String y = w.substring(1);
        while (a == b && x.length() > 0 && y.length() > 0) {
            a = x.charAt(0);
            v = x;
            x = v.substring(1);
            b = y.charAt(0);
            w = y;
            y = w.substring(1);
        }
        if (a == b) {
            distance = x.isEmpty() ? y.length() : x.length();
            this.memo.put(key, distance);
            return distance;
        }
        distance = this.memoizedDistance(x, w);
        if (0 == distance) {
            this.memo.put(key, 1);
            return 1;
        }
        int minDistance = distance;
        distance = this.memoizedDistance(v, y);
        if (0 == distance) {
            this.memo.put(key, 1);
            return 1;
        }
        if (distance < minDistance) {
            minDistance = distance;
        }
        if (0 == (distance = this.memoizedDistance(x, y))) {
            this.memo.put(key, 1);
            return 1;
        }
        if (distance < minDistance) {
            minDistance = distance;
        }
        if (x.length() > 0 && y.length() > 0) {
            char a1 = x.charAt(0);
            char b1 = y.charAt(0);
            if (a == b1 && a1 == b) {
                distance = this.memoizedDistance(this.f(v, 1), this.f(w, 1));
                if (0 == distance) {
                    this.memo.put(key, 1);
                    return 1;
                }
                if (distance < minDistance) {
                    minDistance = distance;
                }
            }
        }
        distance = 1 + minDistance;
        this.memo.put(key, distance);
        return distance;
    }
}

