/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.distance.factory;

import com.github.liblevenshtein.distance.IDistance;
import com.github.liblevenshtein.distance.MemoizedMergeAndSplit;
import com.github.liblevenshtein.distance.MemoizedStandard;
import com.github.liblevenshtein.distance.MemoizedTransposition;
import com.github.liblevenshtein.distance.factory.IDistanceFactory;
import com.github.liblevenshtein.transducer.Algorithm;
import java.io.Serializable;
import lombok.NonNull;

public class MemoizedDistanceFactory
implements IDistanceFactory<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile IDistance<String> standard = null;
    private volatile IDistance<String> transposition = null;
    private volatile IDistance<String> mergeAndSplit = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDistance<String> build(@NonNull Algorithm algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        switch (algorithm) {
            case STANDARD: {
                if (null == this.standard) {
                    MemoizedDistanceFactory memoizedDistanceFactory = this;
                    synchronized (memoizedDistanceFactory) {
                        if (null == this.standard) {
                            this.standard = new MemoizedStandard();
                        }
                    }
                }
                return this.standard;
            }
            case TRANSPOSITION: {
                if (null == this.transposition) {
                    MemoizedDistanceFactory memoizedDistanceFactory = this;
                    synchronized (memoizedDistanceFactory) {
                        if (null == this.transposition) {
                            this.transposition = new MemoizedTransposition();
                        }
                    }
                }
                return this.transposition;
            }
            case MERGE_AND_SPLIT: {
                if (null == this.mergeAndSplit) {
                    MemoizedDistanceFactory memoizedDistanceFactory = this;
                    synchronized (memoizedDistanceFactory) {
                        if (null == this.mergeAndSplit) {
                            this.mergeAndSplit = new MemoizedMergeAndSplit();
                        }
                    }
                }
                return this.mergeAndSplit;
            }
        }
        throw new IllegalArgumentException("Unrecognized algorithm: " + (Object)((Object)algorithm));
    }
}

