/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.serialization;

import com.github.liblevenshtein.serialization.Serializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializer
implements Serializer {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(AbstractSerializer.class);
    @NonNull
    private FileSystem fileSystem = FileSystems.getDefault();

    @Override
    public void serialize(@NonNull Serializable object, @NonNull Path path) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        log.info("Serializing instance of class [{}] to filesystem path [{}]", object.getClass(), (Object)path);
        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
            this.serialize(object, stream);
        }
    }

    @Override
    public void serialize(@NonNull Serializable object, @NonNull File file) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        log.info("Serializing instance of class [{}] to file [{}]", object.getClass(), (Object)file);
        this.serialize(object, file.toPath());
    }

    @Override
    public void serialize(@NonNull Serializable object, @NonNull String path) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        log.info("Serializing instance of class [{}] to string path [{}]", object.getClass(), (Object)path);
        this.serialize(object, this.fileSystem.getPath(path, new String[0]));
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull Path path) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        log.info("Deserilizing instance of [{}] from path [{}]", type, (Object)path);
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            Type Type2 = this.deserialize(type, stream);
            return Type2;
        }
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull File file) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        log.info("Deserilizing instance of [{}] from file [{}]", type, (Object)file);
        return this.deserialize(type, file.toPath());
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull URL url) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        log.info("Deserilizing instance of [{}] from url [{}]", type, (Object)url);
        return this.deserialize(type, url.openStream());
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull URI uri) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        log.info("Deserilizing instance of [{}] from uri [{}]", type, (Object)uri);
        return this.deserialize(type, uri.toURL());
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull String pathOrUri) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (pathOrUri == null) {
            throw new IllegalArgumentException("pathOrUri is null");
        }
        try {
            log.info("Attempting to deserialize instance of [{}] from uri [{}]", type, (Object)pathOrUri);
            return this.deserialize(type, URI.create(pathOrUri));
        }
        catch (IllegalArgumentException exception) {
            log.warn("Invalid uri [{}]", (Object)pathOrUri);
            log.info("Attempting to deserialize instance of [{}] from path [{}]", type, (Object)pathOrUri);
            return this.deserialize(type, this.fileSystem.getPath(pathOrUri, new String[0]));
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public AbstractSerializer fileSystem(@NonNull FileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("fileSystem is null");
        }
        this.fileSystem = fileSystem;
        return this;
    }
}

