/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.serialization;

import com.github.liblevenshtein.serialization.AbstractSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeSerializer
extends AbstractSerializer {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(BytecodeSerializer.class);

    @Override
    public void serialize(@NonNull Serializable object, @NonNull OutputStream stream) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        log.info("Serializing an instance of [{}] to a stream", object.getClass());
        ObjectOutputStream objectStream = new ObjectOutputStream(stream);
        objectStream.writeObject(object);
    }

    @Override
    public byte[] serialize(@NonNull Serializable object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        log.info("Serializing an instance of [{}] to a byte array", object.getClass());
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.serialize(object, stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull InputStream stream) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        log.info("Deserializing an instance of [{}] from a stream", type);
        ObjectInputStream objectStream = new ObjectInputStream(stream);
        return (Type)((Serializable)objectStream.readObject());
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull byte[] bytes) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        log.info("Deserializing an instance of [{}] from a byte array", type);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            Type Type2 = this.deserialize(type, stream);
            return Type2;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "BytecodeSerializer()";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BytecodeSerializer)) {
            return false;
        }
        BytecodeSerializer other = (BytecodeSerializer)o;
        return other.canEqual(this);
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof BytecodeSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int result = 1;
        return result;
    }
}

