/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.serialization;

import com.github.liblevenshtein.collection.dictionary.Dawg;
import com.github.liblevenshtein.collection.dictionary.SortedDawg;
import com.github.liblevenshtein.serialization.AbstractSerializer;
import com.github.liblevenshtein.serialization.ProtobufSerializer;
import com.github.liblevenshtein.serialization.Serializer;
import com.github.liblevenshtein.transducer.Algorithm;
import com.github.liblevenshtein.transducer.Transducer;
import com.github.liblevenshtein.transducer.TransducerAttributes;
import com.github.liblevenshtein.transducer.factory.TransducerBuilder;
import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.TreeSet;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextSerializer
extends AbstractSerializer {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(PlainTextSerializer.class);
    private static final String MAX_DISTANCE = "maxDistance";
    private static final String INCLUDE_DISTANCE = "includeDistance";
    private static final String ALGORITHM = "algorithm";
    private static final String IS_SORTED = "isSorted";
    private static final String DICTIONARY = "dictionary";
    private boolean isSorted = false;
    private final Serializer serializer = new ProtobufSerializer();

    @Override
    public void serialize(@NonNull Serializable object, @NonNull OutputStream stream) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        log.info("Serializing instance of [{}] to stream", object.getClass());
        if (object instanceof SortedDawg) {
            Collection<String> dictionary = this.dictionaryFor((SortedDawg)object);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
                for (String term : dictionary) {
                    writer.write(term);
                    writer.newLine();
                }
            }
            return;
        }
        if (object instanceof Transducer) {
            Transducer transducer = (Transducer)object;
            TransducerAttributes attributes = transducer.attributes();
            Collection<String> dictionary = this.dictionaryFor(attributes.dictionary());
            PropertiesExtensions.setCollection(PropertiesExtensions.setBoolean(PropertiesExtensions.setAlgorithm(PropertiesExtensions.setBoolean(PropertiesExtensions.setInteger(new Properties(), MAX_DISTANCE, attributes.maxDistance()), INCLUDE_DISTANCE, attributes.includeDistance()), ALGORITHM, attributes.algorithm()), IS_SORTED, this.isSorted), DICTIONARY, dictionary).store(stream, MessageFormat.format("Serialized on {0,date,long} at {0,time,full}", new Date()));
            return;
        }
        throw this.unsupportedType(object.getClass());
    }

    @Override
    public byte[] serialize(@NonNull Serializable object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        log.info("Serializing instance of [{}] to byte array", object.getClass());
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.serialize(object, stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull InputStream stream) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        log.info("Deserializing an instance of [{}] from a stream", type);
        if (SortedDawg.class.isAssignableFrom(type)) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                if (this.isSorted) {
                    log.info("Assuming the dictionary is sorted for deserialization");
                    SortedDawg dictionary = new SortedDawg();
                    Object term = reader.readLine();
                    while (null != term) {
                        dictionary.add((String)term);
                        term = reader.readLine();
                    }
                    dictionary.finish();
                    term = dictionary;
                    return (Type)term;
                }
                TreeSet<String> dictionary = new TreeSet<String>();
                String term = reader.readLine();
                while (null != term) {
                    dictionary.add(term);
                    term = reader.readLine();
                }
                SortedDawg sortedDawg = new SortedDawg(dictionary);
                return (Type)sortedDawg;
            }
        }
        if (Transducer.class.isAssignableFrom(type)) {
            Properties properties = new Properties();
            properties.load(stream);
            return (Type)new TransducerBuilder().dictionary(PropertiesExtensions.getCollection(properties, DICTIONARY), PropertiesExtensions.getBoolean(properties, IS_SORTED)).algorithm(PropertiesExtensions.getAlgorithm(properties, ALGORITHM)).defaultMaxDistance(PropertiesExtensions.getInteger(properties, MAX_DISTANCE)).includeDistance(PropertiesExtensions.getBoolean(properties, INCLUDE_DISTANCE)).build();
        }
        throw this.unsupportedType(type);
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull byte[] bytes) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        log.info("Deserializing an instance of [{}] from a byte array", type);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            Type Type2 = this.deserialize(type, stream);
            return Type2;
        }
    }

    private Collection<String> dictionaryFor(@NonNull Dawg dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary is null");
        }
        if (!this.isSorted) {
            return dictionary;
        }
        ArrayList<String> sorted = new ArrayList<String>(dictionary);
        Collections.sort(sorted);
        return sorted;
    }

    private IllegalArgumentException unsupportedType(Class<?> type) {
        String message = String.format("Unsupported type [%s] for serializer [%s]", type, this.getClass());
        return new IllegalArgumentException(message);
    }

    @SuppressFBWarnings(justification="generated code")
    public PlainTextSerializer() {
    }

    @ConstructorProperties(value={"isSorted"})
    @SuppressFBWarnings(justification="generated code")
    public PlainTextSerializer(boolean isSorted) {
        this.isSorted = isSorted;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "PlainTextSerializer(isSorted=" + this.isSorted + ", serializer=" + this.serializer + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlainTextSerializer)) {
            return false;
        }
        PlainTextSerializer other = (PlainTextSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSorted != other.isSorted) {
            return false;
        }
        Serializer this$serializer = this.serializer;
        Serializer other$serializer = other.serializer;
        return !(this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof PlainTextSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSorted ? 79 : 97);
        Serializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        return result;
    }

    public static class PropertiesExtensions {
        public static String getValue(Properties self, String key) {
            String value = self.getProperty(key);
            PropertiesExtensions.assertNotNull(key, value);
            return value;
        }

        public static Properties setInteger(Properties self, String key, int value) {
            self.setProperty(key, Integer.toString(value));
            return self;
        }

        public static int getInteger(Properties self, String key) {
            String value = PropertiesExtensions.getValue(self, key);
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                String message = String.format("Invalid integer [%s] for property [%s]", value, key);
                throw new IllegalArgumentException(message, exception);
            }
        }

        public static Properties setBoolean(Properties self, String key, boolean value) {
            self.setProperty(key, Boolean.toString(value));
            return self;
        }

        public static boolean getBoolean(Properties self, String key) {
            String value = PropertiesExtensions.getValue(self, key);
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            String message = String.format("Invalid boolean [%s] for property [%s]", value, key);
            throw new IllegalArgumentException(message);
        }

        public static Properties setCollection(Properties self, String key, Collection<String> collection) {
            self.setProperty(key, Joiner.on((String)"\\n").join(collection));
            return self;
        }

        public static Collection<String> getCollection(Properties self, String key) {
            String value = PropertiesExtensions.getValue(self, key);
            String[] collection = value.split("\\\\n");
            return Arrays.asList(collection);
        }

        public static Properties setAlgorithm(Properties self, String key, Algorithm algorithm) {
            self.setProperty(key, algorithm.name());
            return self;
        }

        public static Algorithm getAlgorithm(Properties self, String key) {
            String value = PropertiesExtensions.getValue(self, key);
            return Algorithm.valueOf(value);
        }

        private static void assertNotNull(String key, String value) {
            if (null == value) {
                String message = String.format("No value defined for property [%s]", key);
                throw new IllegalArgumentException(message);
            }
        }
    }
}

