/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.serialization;

import com.github.liblevenshtein.collection.dictionary.Dawg;
import com.github.liblevenshtein.collection.dictionary.DawgNode;
import com.github.liblevenshtein.collection.dictionary.FinalDawgNode;
import com.github.liblevenshtein.collection.dictionary.SortedDawg;
import com.github.liblevenshtein.proto.LibLevenshteinProtos;
import com.github.liblevenshtein.serialization.AbstractSerializer;
import com.github.liblevenshtein.transducer.Algorithm;
import com.github.liblevenshtein.transducer.Transducer;
import com.github.liblevenshtein.transducer.TransducerAttributes;
import com.github.liblevenshtein.transducer.factory.TransducerBuilder;
import com.google.protobuf.CodedInputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectRBTreeMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSerializer
extends AbstractSerializer {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ProtobufSerializer.class);

    @Override
    public void serialize(@NonNull Serializable object, @NonNull OutputStream stream) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        log.info("Serializing an instance of [{}] to a stream", object.getClass());
        if (object instanceof SortedDawg) {
            SortedDawg dawg = (SortedDawg)object;
            LibLevenshteinProtos.Dawg proto = this.protoOf(dawg);
            proto.writeTo(stream);
            return;
        }
        if (object instanceof Transducer) {
            Transducer transducer = (Transducer)object;
            LibLevenshteinProtos.Transducer proto = this.protoOf(transducer);
            proto.writeTo(stream);
            return;
        }
        throw this.unknownType(object.getClass());
    }

    @Override
    public byte[] serialize(@NonNull Serializable object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        log.info("Serializing an instance of [{}] to a byte array", object.getClass());
        if (object instanceof SortedDawg) {
            SortedDawg dawg = (SortedDawg)object;
            LibLevenshteinProtos.Dawg proto = this.protoOf(dawg);
            return proto.toByteArray();
        }
        if (object instanceof Transducer) {
            Transducer transducer = (Transducer)object;
            LibLevenshteinProtos.Transducer proto = this.protoOf(transducer);
            return proto.toByteArray();
        }
        throw this.unknownType(object.getClass());
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull InputStream stream) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        log.info("Deserializing an instance of [{}] from a stream", type);
        CodedInputStream protoStream = CodedInputStream.newInstance((InputStream)stream);
        protoStream.setRecursionLimit(Integer.MAX_VALUE);
        protoStream.setSizeLimit(Integer.MAX_VALUE);
        if (SortedDawg.class.isAssignableFrom(type)) {
            LibLevenshteinProtos.Dawg proto = LibLevenshteinProtos.Dawg.parseFrom(protoStream);
            return (Type)this.modelOf(proto);
        }
        if (Transducer.class.isAssignableFrom(type)) {
            LibLevenshteinProtos.Transducer proto = LibLevenshteinProtos.Transducer.parseFrom(protoStream);
            return (Type)this.modelOf(proto);
        }
        throw this.unknownType(type);
    }

    @Override
    public <Type extends Serializable> Type deserialize(@NonNull Class<Type> type, @NonNull byte[] bytes) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        log.info("Deserializing an instance of [{}] from a byte array", type);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            Type Type2 = this.deserialize(type, stream);
            return Type2;
        }
    }

    protected DawgNode modelOf(LibLevenshteinProtos.DawgNode proto, Map<LibLevenshteinProtos.DawgNode, DawgNode> nodes) {
        if (nodes.containsKey(proto)) {
            return nodes.get(proto);
        }
        Char2ObjectRBTreeMap edges = new Char2ObjectRBTreeMap();
        for (LibLevenshteinProtos.DawgNode.Edge edge : proto.getEdgeList()) {
            char label = (char)edge.getCharKey();
            edges.put(label, (Object)this.modelOf(edge.getValue(), nodes));
        }
        DawgNode node = proto.getIsFinal() ? new FinalDawgNode((Char2ObjectMap<DawgNode>)edges) : new DawgNode((Char2ObjectMap<DawgNode>)edges);
        nodes.put(proto, node);
        return node;
    }

    protected SortedDawg modelOf(LibLevenshteinProtos.Dawg proto) {
        IdentityHashMap<LibLevenshteinProtos.DawgNode, DawgNode> nodes = new IdentityHashMap<LibLevenshteinProtos.DawgNode, DawgNode>();
        DawgNode root = this.modelOf(proto.getRoot(), nodes);
        return new SortedDawg(proto.getSize(), root);
    }

    protected Transducer<DawgNode, Object> modelOf(LibLevenshteinProtos.Transducer proto) {
        return (Transducer)new TransducerBuilder().dictionary(this.modelOf(proto.getDictionary())).algorithm(this.modelOf(proto.getAlgorithm())).defaultMaxDistance(proto.getDefaultMaxDistance()).includeDistance(proto.getIncludeDistance()).build();
    }

    protected Algorithm modelOf(LibLevenshteinProtos.Transducer.Algorithm proto) {
        switch (proto) {
            case STANDARD: {
                return Algorithm.STANDARD;
            }
            case TRANSPOSITION: {
                return Algorithm.TRANSPOSITION;
            }
            case MERGE_AND_SPLIT: {
                return Algorithm.MERGE_AND_SPLIT;
            }
        }
        throw this.unknownAlgorithm(proto);
    }

    protected LibLevenshteinProtos.Transducer protoOf(Transducer<DawgNode, Object> transducer) {
        TransducerAttributes<DawgNode, Object> attributes = transducer.attributes();
        return LibLevenshteinProtos.Transducer.newBuilder().setDefaultMaxDistance(attributes.maxDistance()).setIncludeDistance(attributes.includeDistance()).setAlgorithm(this.protoOf(attributes.algorithm())).setDictionary(this.protoOf(attributes.dictionary())).build();
    }

    protected LibLevenshteinProtos.Transducer.Algorithm protoOf(Algorithm algorithm) {
        switch (algorithm) {
            case STANDARD: {
                return LibLevenshteinProtos.Transducer.Algorithm.STANDARD;
            }
            case TRANSPOSITION: {
                return LibLevenshteinProtos.Transducer.Algorithm.TRANSPOSITION;
            }
            case MERGE_AND_SPLIT: {
                return LibLevenshteinProtos.Transducer.Algorithm.MERGE_AND_SPLIT;
            }
        }
        throw this.unknownAlgorithm(algorithm);
    }

    protected LibLevenshteinProtos.Dawg protoOf(Dawg dawg) {
        if (dawg instanceof SortedDawg) {
            return this.protoOf((SortedDawg)dawg);
        }
        String message = String.format("Unsupported Dawg type [%s]", dawg.getClass());
        throw new IllegalArgumentException(message);
    }

    protected LibLevenshteinProtos.Dawg protoOf(SortedDawg dawg) {
        IdentityHashMap<DawgNode, LibLevenshteinProtos.DawgNode> nodes = new IdentityHashMap<DawgNode, LibLevenshteinProtos.DawgNode>();
        return LibLevenshteinProtos.Dawg.newBuilder().setSize(dawg.size()).setRoot(this.protoOf(dawg.root(), nodes)).build();
    }

    protected LibLevenshteinProtos.DawgNode protoOf(DawgNode node, Map<DawgNode, LibLevenshteinProtos.DawgNode> nodes) {
        if (nodes.containsKey(node)) {
            return nodes.get(node);
        }
        LibLevenshteinProtos.DawgNode.Builder builder = LibLevenshteinProtos.DawgNode.newBuilder();
        builder.setIsFinal(node.isFinal());
        for (Char2ObjectMap.Entry edge : node.edges().char2ObjectEntrySet()) {
            builder.addEdge(this.protoOf(edge.getCharKey(), (DawgNode)edge.getValue(), nodes));
        }
        LibLevenshteinProtos.DawgNode proto = builder.build();
        nodes.put(node, proto);
        return proto;
    }

    protected LibLevenshteinProtos.DawgNode.Edge protoOf(char label, DawgNode node, Map<DawgNode, LibLevenshteinProtos.DawgNode> nodes) {
        return LibLevenshteinProtos.DawgNode.Edge.newBuilder().setCharKey(label).setValue(this.protoOf(node, nodes)).build();
    }

    private IllegalArgumentException unknownType(Class<?> type) {
        String message = String.format("Unknown type [%s]", type);
        return new IllegalArgumentException(message);
    }

    private <AlgorithmType> IllegalArgumentException unknownAlgorithm(AlgorithmType algorithm) {
        String message = String.format("Unknown Algorithm [%s]", algorithm);
        return new IllegalArgumentException(message);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ProtobufSerializer()";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtobufSerializer)) {
            return false;
        }
        ProtobufSerializer other = (ProtobufSerializer)o;
        return other.canEqual(this);
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ProtobufSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int result = 1;
        return result;
    }
}

