/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.State;
import java.io.Serializable;

public abstract class DistanceFunction
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract int at(State var1, int var2);

    public static class ForSpecialPositions
    extends DistanceFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public int at(State state, int queryLength) {
            int minimumDistance = Integer.MAX_VALUE;
            for (Position position : state) {
                int e;
                int i;
                int distance;
                if (position.isSpecial() || (distance = queryLength - (i = position.termIndex()) + (e = position.numErrors())) >= minimumDistance) continue;
                minimumDistance = distance;
            }
            return minimumDistance;
        }
    }

    public static class ForStandardPositions
    extends DistanceFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public int at(State state, int queryLength) {
            int minimumDistance = Integer.MAX_VALUE;
            for (Position position : state) {
                int e;
                int i = position.termIndex();
                int distance = queryLength - i + (e = position.numErrors());
                if (distance >= minimumDistance) continue;
                minimumDistance = distance;
            }
            return minimumDistance;
        }
    }
}

