/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public final class Intersection<DictionaryNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Intersection<DictionaryNode> prevIntersection;
    private final char label;
    private final DictionaryNode dictionaryNode;
    private final State levenshteinState;

    public Intersection(DictionaryNode dictionaryRoot, State initialState) {
        this(null, '\u0000', dictionaryRoot, initialState);
    }

    public String candidate() {
        return this.buffer().toString();
    }

    private StringBuilder buffer() {
        StringBuilder buffer;
        if (this.prevIntersection != null) {
            buffer = super.buffer();
            buffer.append(this.label);
        } else {
            buffer = new StringBuilder();
        }
        return buffer;
    }

    @SuppressFBWarnings(justification="generated code")
    public Intersection<DictionaryNode> prevIntersection() {
        return this.prevIntersection;
    }

    @SuppressFBWarnings(justification="generated code")
    public char label() {
        return this.label;
    }

    @SuppressFBWarnings(justification="generated code")
    public DictionaryNode dictionaryNode() {
        return this.dictionaryNode;
    }

    @SuppressFBWarnings(justification="generated code")
    public State levenshteinState() {
        return this.levenshteinState;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Intersection)) {
            return false;
        }
        Intersection other = (Intersection)o;
        Intersection<DictionaryNode> this$prevIntersection = this.prevIntersection();
        Intersection<DictionaryNode> other$prevIntersection = other.prevIntersection();
        if (this$prevIntersection == null ? other$prevIntersection != null : !((Object)this$prevIntersection).equals(other$prevIntersection)) {
            return false;
        }
        if (this.label() != other.label()) {
            return false;
        }
        DictionaryNode this$dictionaryNode = this.dictionaryNode();
        DictionaryNode other$dictionaryNode = other.dictionaryNode();
        if (this$dictionaryNode == null ? other$dictionaryNode != null : !this$dictionaryNode.equals(other$dictionaryNode)) {
            return false;
        }
        State this$levenshteinState = this.levenshteinState();
        State other$levenshteinState = other.levenshteinState();
        return !(this$levenshteinState == null ? other$levenshteinState != null : !((Object)this$levenshteinState).equals(other$levenshteinState));
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Intersection<DictionaryNode> $prevIntersection = this.prevIntersection();
        result = result * 59 + ($prevIntersection == null ? 43 : ((Object)$prevIntersection).hashCode());
        result = result * 59 + this.label();
        DictionaryNode $dictionaryNode = this.dictionaryNode();
        result = result * 59 + ($dictionaryNode == null ? 43 : $dictionaryNode.hashCode());
        State $levenshteinState = this.levenshteinState();
        result = result * 59 + ($levenshteinState == null ? 43 : ((Object)$levenshteinState).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Intersection(prevIntersection=" + this.prevIntersection() + ", label=" + this.label() + ", dictionaryNode=" + this.dictionaryNode() + ", levenshteinState=" + this.levenshteinState() + ")";
    }

    @ConstructorProperties(value={"prevIntersection", "label", "dictionaryNode", "levenshteinState"})
    @SuppressFBWarnings(justification="generated code")
    public Intersection(Intersection<DictionaryNode> prevIntersection, char label, DictionaryNode dictionaryNode, State levenshteinState) {
        this.prevIntersection = prevIntersection;
        this.label = label;
        this.dictionaryNode = dictionaryNode;
        this.levenshteinState = levenshteinState;
    }
}

