/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.collection.AbstractIterator;
import com.github.liblevenshtein.transducer.Intersection;
import com.github.liblevenshtein.transducer.State;
import com.github.liblevenshtein.transducer.StateTransitionFunction;
import com.github.liblevenshtein.transducer.TransducerAttributes;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import lombok.NonNull;

public class LazyTransducerCollection<DictionaryNode, CandidateType>
extends AbstractIterator<CandidateType>
implements Iterable<CandidateType> {
    @NonNull
    private final String term;
    private final int maxDistance;
    @NonNull
    private final TransducerAttributes<DictionaryNode, CandidateType> attributes;
    private final Deque<Intersection<DictionaryNode>> pendingQueue = new ArrayDeque<Intersection<DictionaryNode>>();
    private final StateTransitionFunction stateTransition;
    private final int a;
    private int k;
    private int i;
    private CharIterator labels = null;
    private Intersection<DictionaryNode> intersection = null;

    public LazyTransducerCollection(@NonNull String term, int maxDistance, @NonNull TransducerAttributes<DictionaryNode, CandidateType> attributes) {
        if (term == null) {
            throw new IllegalArgumentException("term is null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        this.term = term;
        this.maxDistance = maxDistance;
        this.attributes = attributes;
        this.pendingQueue.addLast(new Intersection<DictionaryNode>(attributes.dictionaryRoot(), attributes.initialState()));
        this.stateTransition = attributes.stateTransitionFactory().build(maxDistance, term.length());
        this.a = maxDistance < 0x3FFFFFFF ? (maxDistance << 1) + 1 : Integer.MAX_VALUE;
    }

    @Override
    public Iterator<CandidateType> iterator() {
        return this;
    }

    @Override
    protected void advance() {
        while (null == this.next && (null != this.labels && this.labels.hasNext() || !this.pendingQueue.isEmpty())) {
            State levenshteinState;
            DictionaryNode dictionaryNode;
            if (null != this.labels && this.labels.hasNext()) {
                int distance;
                dictionaryNode = this.intersection.dictionaryNode();
                levenshteinState = this.intersection.levenshteinState();
                char label = this.labels.nextChar();
                DictionaryNode nextDictionaryNode = this.attributes.dictionaryTransition().of(dictionaryNode, label);
                boolean[] characteristicVector = this.characteristicVector(label, this.term, this.k, this.i);
                State nextLevenshteinState = this.stateTransition.of(levenshteinState, characteristicVector);
                if (null == nextLevenshteinState) continue;
                Intersection<DictionaryNode> nextIntersection = new Intersection<DictionaryNode>(this.intersection, label, nextDictionaryNode, nextLevenshteinState);
                this.pendingQueue.addLast(nextIntersection);
                if (!this.attributes.isFinal().at(nextDictionaryNode) || (distance = this.attributes.minDistance().at(nextLevenshteinState, this.term.length())) > this.maxDistance) continue;
                String nextCandidate = nextIntersection.candidate();
                this.next = this.attributes.candidateFactory().build(nextCandidate, distance);
                continue;
            }
            this.intersection = this.pendingQueue.removeFirst();
            dictionaryNode = this.intersection.dictionaryNode();
            levenshteinState = this.intersection.levenshteinState();
            this.i = levenshteinState.head().termIndex();
            int b = this.term.length() - this.i;
            this.k = this.a < b ? this.a : b;
            this.labels = this.attributes.dictionaryTransition().of(dictionaryNode);
        }
    }

    private boolean[] characteristicVector(char x, String term, int k, int i) {
        boolean[] characteristicVector = new boolean[k];
        for (int j = 0; j < k; ++j) {
            characteristicVector[j] = x == term.charAt(i + j);
        }
        return characteristicVector;
    }
}

