/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.State;
import com.github.liblevenshtein.transducer.StateIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;

public abstract class MergeFunction
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract void into(State var1, State var2);

    protected void insertAfter(State state, Position curr, Position next) {
        if (null == curr) {
            state.head(next);
        } else {
            state.insertAfter(curr, next);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    protected MergeFunction() {
    }

    public static class ForSpecialPositions
    extends MergeFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public void into(State state, State positions) {
            for (Position a : positions) {
                boolean t;
                int f;
                int j;
                Position b;
                int i = a.termIndex();
                int e = a.numErrors();
                boolean s = a.isSpecial();
                StateIterator iter = state.iterator();
                Position prevB = null;
                while (iter.hasNext()) {
                    b = iter.peek();
                    j = b.termIndex();
                    f = b.numErrors();
                    t = b.isSpecial();
                    if (e >= f && (e != f || i >= j && (i != j || s || !t))) break;
                    prevB = b;
                    iter.next();
                }
                if (iter.hasNext()) {
                    b = (Position)iter.next();
                    j = b.termIndex();
                    f = b.numErrors();
                    t = b.isSpecial();
                    if (j == i && f == e && t == s) continue;
                    this.insertAfter(state, prevB, a);
                    continue;
                }
                this.insertAfter(state, prevB, a);
            }
        }
    }

    public static class ForStandardPositions
    extends MergeFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public void into(State state, State positions) {
            for (Position a : positions) {
                int f;
                int j;
                Position b;
                int i = a.termIndex();
                int e = a.numErrors();
                StateIterator iter = state.iterator();
                Position prevB = null;
                while (iter.hasNext()) {
                    b = iter.peek();
                    j = b.termIndex();
                    f = b.numErrors();
                    if (e >= f && (e != f || i >= j)) break;
                    prevB = b;
                    iter.next();
                }
                if (iter.hasNext()) {
                    b = iter.peek();
                    j = b.termIndex();
                    f = b.numErrors();
                    if (j == i && f == e) continue;
                    this.insertAfter(state, prevB, a);
                    continue;
                }
                this.insertAfter(state, prevB, a);
            }
        }
    }
}

