/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.PositionTransitionFunction;
import com.github.liblevenshtein.transducer.State;

public class StandardPositionTransitionFunction
extends PositionTransitionFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public State of(int n, Position position, boolean[] characteristicVector, int offset) {
        int i = position.termIndex();
        int e = position.numErrors();
        int h = i - offset;
        int w = characteristicVector.length;
        if (e < n) {
            if (h <= w - 2) {
                int b;
                int a = n - e < Integer.MAX_VALUE ? n - e + 1 : Integer.MAX_VALUE;
                int k = a < (b = w - h) ? a : b;
                int j = this.indexOf(characteristicVector, k, h);
                if (0 == j) {
                    return this.stateFactory.build(this.positionFactory.build(1 + i, e));
                }
                if (j > 0) {
                    return this.stateFactory.build(this.positionFactory.build(i, e + 1), this.positionFactory.build(i + 1, e + 1), this.positionFactory.build(i + j + 1, e + j));
                }
                return this.stateFactory.build(this.positionFactory.build(i, e + 1), this.positionFactory.build(i + 1, e + 1));
            }
            if (h == w - 1) {
                if (characteristicVector[h]) {
                    return this.stateFactory.build(this.positionFactory.build(i + 1, e));
                }
                return this.stateFactory.build(this.positionFactory.build(i, e + 1), this.positionFactory.build(i + 1, e + 1));
            }
            return this.stateFactory.build(this.positionFactory.build(i, e + 1));
        }
        if (e == n && h <= w - 1 && characteristicVector[h]) {
            return this.stateFactory.build(this.positionFactory.build(i + 1, n));
        }
        return null;
    }
}

