/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.StateIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Comparator;

public class State
implements Iterable<Position>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Position head = null;

    public State head(Position head) {
        head.next(this.head);
        this.head = head;
        return this;
    }

    public StateIterator iterator() {
        return new StateIterator(this, this.head, null, null);
    }

    public State add(Position next) {
        if (null == this.head) {
            this.head = next;
        } else {
            Position curr = this.head;
            while (null != curr.next()) {
                curr = curr.next();
            }
            curr.next(next);
        }
        return this;
    }

    public State insertAfter(Position curr, Position next) {
        if (null != curr) {
            next.next(curr.next());
            curr.next(next);
        } else {
            this.add(next);
        }
        return this;
    }

    public State remove(Position prev, Position curr) {
        if (null != prev) {
            prev.next(curr.next());
        } else {
            this.head = this.head.next();
        }
        return this;
    }

    private Position mergeSort(Comparator<Position> comparator, Position lhsHead) {
        if (null == lhsHead || null == lhsHead.next()) {
            return lhsHead;
        }
        Position middle = this.middle(lhsHead);
        Position rhsHead = middle.next();
        middle.next(null);
        return this.merge(comparator, this.mergeSort(comparator, lhsHead), this.mergeSort(comparator, rhsHead));
    }

    private Position merge(Comparator<Position> comparator, Position lhsHead, Position rhsHead) {
        Position next;
        Position curr = next = new Position(-1, -1);
        while (null != lhsHead && null != rhsHead) {
            if (comparator.compare(lhsHead, rhsHead) <= 0) {
                curr.next(lhsHead);
                lhsHead = lhsHead.next();
            } else {
                curr.next(rhsHead);
                rhsHead = rhsHead.next();
            }
            curr = curr.next();
        }
        if (null != rhsHead) {
            curr.next(rhsHead);
        } else if (null != lhsHead) {
            curr.next(lhsHead);
        }
        curr = next.next();
        return curr;
    }

    private Position middle(Position head) {
        Position slow = head;
        Position fast = head;
        while (null != fast.next() && null != fast.next().next()) {
            slow = slow.next();
            fast = fast.next().next();
        }
        return slow;
    }

    public State sort(Comparator<Position> comparator) {
        this.head = this.mergeSort(comparator, this.head);
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public State() {
    }

    @SuppressFBWarnings(justification="generated code")
    public Position head() {
        return this.head;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Position this$head = this.head();
        Position other$head = other.head();
        return !(this$head == null ? other$head != null : !((Object)this$head).equals(other$head));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof State;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Position $head = this.head();
        result = result * 59 + ($head == null ? 43 : ((Object)$head).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "State(head=" + this.head() + ")";
    }
}

