/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.collection.AbstractIterator;
import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;

public class StateIterator
extends AbstractIterator<Position> {
    private final State state;
    private Position lookAhead;
    private Position curr;
    private Position prev;

    public void insert(Position position) {
        if (null != this.curr) {
            this.state.insertAfter(this.curr, position);
        } else {
            this.state.head(position);
        }
        this.lookAhead = position;
    }

    public Position peek() {
        this.advance();
        return (Position)this.next;
    }

    @Override
    public void remove() {
        if (null != this.curr) {
            this.state.remove(this.prev, this.curr);
            this.curr = null;
        }
    }

    @Override
    protected void advance() {
        if (null == this.next && null != this.lookAhead) {
            this.next = this.lookAhead;
            if (null != this.curr) {
                this.prev = this.curr;
            }
            this.curr = (Position)this.next;
            this.lookAhead = this.lookAhead.next();
        }
    }

    public StateIterator copy() {
        StateIterator copy = new StateIterator(this.state, this.lookAhead, this.curr, this.prev);
        copy.next = this.next;
        return copy;
    }

    @ConstructorProperties(value={"state", "lookAhead", "curr", "prev"})
    @SuppressFBWarnings(justification="generated code")
    public StateIterator(State state, Position lookAhead, Position curr, Position prev) {
        this.state = state;
        this.lookAhead = lookAhead;
        this.curr = curr;
        this.prev = prev;
    }
}

