/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.MergeFunction;
import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.PositionTransitionFunction;
import com.github.liblevenshtein.transducer.State;
import com.github.liblevenshtein.transducer.UnsubsumeFunction;
import com.github.liblevenshtein.transducer.factory.PositionTransitionFactory;
import com.github.liblevenshtein.transducer.factory.StateFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Comparator;

public class StateTransitionFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Comparator<Position> comparator;
    private StateFactory stateFactory;
    private PositionTransitionFactory transitionFactory;
    private MergeFunction merge;
    private UnsubsumeFunction unsubsume;
    private int maxDistance;
    private int queryLength;

    public State of(State currState, boolean[] characteristicVector) {
        PositionTransitionFunction transition = this.transitionFactory.build();
        int offset = currState.head().termIndex();
        State nextState = this.stateFactory.build(new Position[0]);
        int n = this.maxDistance;
        for (Position position : currState) {
            State positions = transition.of(n, position, characteristicVector, offset);
            if (null == positions) continue;
            this.merge.into(nextState, positions);
        }
        this.unsubsume.at(nextState, this.queryLength);
        if (null != nextState.head()) {
            nextState.sort(this.comparator);
            return nextState;
        }
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction comparator(Comparator<Position> comparator) {
        this.comparator = comparator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction stateFactory(StateFactory stateFactory) {
        this.stateFactory = stateFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction transitionFactory(PositionTransitionFactory transitionFactory) {
        this.transitionFactory = transitionFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction merge(MergeFunction merge) {
        this.merge = merge;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction unsubsume(UnsubsumeFunction unsubsume) {
        this.unsubsume = unsubsume;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction maxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFunction queryLength(int queryLength) {
        this.queryLength = queryLength;
        return this;
    }
}

