/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import java.io.Serializable;

public abstract class SubsumesFunction
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract boolean at(Position var1, Position var2, int var3);

    public static class ForMergeAndSplit
    extends SubsumesFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean at(Position lhs, Position rhs, int n) {
            int i = lhs.termIndex();
            int e = lhs.numErrors();
            boolean s = lhs.isSpecial();
            int j = rhs.termIndex();
            int f = rhs.numErrors();
            boolean t = rhs.isSpecial();
            if (s && !t) {
                return false;
            }
            return (i < j ? j - i : i - j) <= f - e;
        }
    }

    public static class ForTransposition
    extends SubsumesFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean at(Position lhs, Position rhs, int n) {
            int i = lhs.termIndex();
            int e = lhs.numErrors();
            boolean s = lhs.isSpecial();
            int j = rhs.termIndex();
            int f = rhs.numErrors();
            boolean t = rhs.isSpecial();
            if (s) {
                if (t) {
                    return i == j;
                }
                return f == n && i == j;
            }
            if (t) {
                return (j < i ? i - j - 1 : j - i + 1) <= f - e;
            }
            return (i < j ? j - i : i - j) <= f - e;
        }
    }

    public static class ForStandardAlgorithm
    extends SubsumesFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean at(Position lhs, Position rhs, int n) {
            int i = lhs.termIndex();
            int e = lhs.numErrors();
            int j = rhs.termIndex();
            int f = rhs.numErrors();
            return (i < j ? j - i : i - j) <= f - e;
        }
    }
}

