/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.ITransducer;
import com.github.liblevenshtein.transducer.LazyTransducerCollection;
import com.github.liblevenshtein.transducer.TransducerAttributes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.NonNull;

public class Transducer<DictionaryNode, CandidateType>
implements ITransducer<CandidateType>,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private TransducerAttributes<DictionaryNode, CandidateType> attributes;

    @Override
    public Iterable<CandidateType> transduce(@NonNull String term) {
        if (term == null) {
            throw new IllegalArgumentException("term is null");
        }
        return this.transduce(term, this.attributes.maxDistance());
    }

    @Override
    public Iterable<CandidateType> transduce(@NonNull String term, int maxDistance) {
        if (term == null) {
            throw new IllegalArgumentException("term is null");
        }
        return new LazyTransducerCollection<DictionaryNode, CandidateType>(term, maxDistance, this.attributes);
    }

    @SuppressFBWarnings(justification="generated code")
    public Transducer<DictionaryNode, CandidateType> attributes(@NonNull TransducerAttributes<DictionaryNode, CandidateType> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        this.attributes = attributes;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transducer)) {
            return false;
        }
        Transducer other = (Transducer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransducerAttributes<DictionaryNode, CandidateType> this$attributes = this.attributes();
        TransducerAttributes<DictionaryNode, CandidateType> other$attributes = other.attributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Transducer;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransducerAttributes<DictionaryNode, CandidateType> $attributes = this.attributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Transducer(attributes=" + this.attributes() + ")";
    }

    @ConstructorProperties(value={"attributes"})
    @SuppressFBWarnings(justification="generated code")
    public Transducer(@NonNull TransducerAttributes<DictionaryNode, CandidateType> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        this.attributes = attributes;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public TransducerAttributes<DictionaryNode, CandidateType> attributes() {
        return this.attributes;
    }
}

