/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.collection.dictionary.Dawg;
import com.github.liblevenshtein.collection.dictionary.IFinalFunction;
import com.github.liblevenshtein.collection.dictionary.ITransitionFunction;
import com.github.liblevenshtein.transducer.Algorithm;
import com.github.liblevenshtein.transducer.DistanceFunction;
import com.github.liblevenshtein.transducer.State;
import com.github.liblevenshtein.transducer.factory.CandidateFactory;
import com.github.liblevenshtein.transducer.factory.StateTransitionFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import lombok.NonNull;

public class TransducerAttributes<DictionaryNode, CandidateType>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int maxDistance = Integer.MAX_VALUE;
    @NonNull
    protected CandidateFactory<CandidateType> candidateFactory;
    @NonNull
    protected StateTransitionFactory stateTransitionFactory;
    @NonNull
    protected DistanceFunction minDistance;
    @NonNull
    protected IFinalFunction<DictionaryNode> isFinal;
    @NonNull
    protected ITransitionFunction<DictionaryNode> dictionaryTransition;
    @NonNull
    protected State initialState;
    @NonNull
    protected DictionaryNode dictionaryRoot;
    @NonNull
    protected Dawg dictionary;
    @NonNull
    protected Algorithm algorithm;
    protected boolean includeDistance;

    @SuppressFBWarnings(justification="generated code")
    TransducerAttributes(int maxDistance, @NonNull CandidateFactory<CandidateType> candidateFactory, @NonNull StateTransitionFactory stateTransitionFactory, @NonNull DistanceFunction minDistance, @NonNull IFinalFunction<DictionaryNode> isFinal, @NonNull ITransitionFunction<DictionaryNode> dictionaryTransition, @NonNull State initialState, @NonNull DictionaryNode dictionaryRoot, @NonNull Dawg dictionary, @NonNull Algorithm algorithm, boolean includeDistance) {
        if (candidateFactory == null) {
            throw new IllegalArgumentException("candidateFactory is null");
        }
        if (stateTransitionFactory == null) {
            throw new IllegalArgumentException("stateTransitionFactory is null");
        }
        if (minDistance == null) {
            throw new IllegalArgumentException("minDistance is null");
        }
        if (isFinal == null) {
            throw new IllegalArgumentException("isFinal is null");
        }
        if (dictionaryTransition == null) {
            throw new IllegalArgumentException("dictionaryTransition is null");
        }
        if (initialState == null) {
            throw new IllegalArgumentException("initialState is null");
        }
        if (dictionaryRoot == null) {
            throw new IllegalArgumentException("dictionaryRoot is null");
        }
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        this.maxDistance = maxDistance;
        this.candidateFactory = candidateFactory;
        this.stateTransitionFactory = stateTransitionFactory;
        this.minDistance = minDistance;
        this.isFinal = isFinal;
        this.dictionaryTransition = dictionaryTransition;
        this.initialState = initialState;
        this.dictionaryRoot = dictionaryRoot;
        this.dictionary = dictionary;
        this.algorithm = algorithm;
        this.includeDistance = includeDistance;
    }

    @SuppressFBWarnings(justification="generated code")
    public static <DictionaryNode, CandidateType> TransducerAttributesBuilder<DictionaryNode, CandidateType> builder() {
        return new TransducerAttributesBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int maxDistance() {
        return this.maxDistance;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public CandidateFactory<CandidateType> candidateFactory() {
        return this.candidateFactory;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public StateTransitionFactory stateTransitionFactory() {
        return this.stateTransitionFactory;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public DistanceFunction minDistance() {
        return this.minDistance;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public IFinalFunction<DictionaryNode> isFinal() {
        return this.isFinal;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public ITransitionFunction<DictionaryNode> dictionaryTransition() {
        return this.dictionaryTransition;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public State initialState() {
        return this.initialState;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public DictionaryNode dictionaryRoot() {
        return this.dictionaryRoot;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public Dawg dictionary() {
        return this.dictionary;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public Algorithm algorithm() {
        return this.algorithm;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean includeDistance() {
        return this.includeDistance;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TransducerAttributes(maxDistance=" + this.maxDistance() + ", dictionary=" + this.dictionary() + ", algorithm=" + (Object)((Object)this.algorithm()) + ", includeDistance=" + this.includeDistance() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransducerAttributes)) {
            return false;
        }
        TransducerAttributes other = (TransducerAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxDistance() != other.maxDistance()) {
            return false;
        }
        Dawg this$dictionary = this.dictionary();
        Dawg other$dictionary = other.dictionary();
        if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
            return false;
        }
        Algorithm this$algorithm = this.algorithm();
        Algorithm other$algorithm = other.algorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        return this.includeDistance() == other.includeDistance();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TransducerAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxDistance();
        Dawg $dictionary = this.dictionary();
        result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
        Algorithm $algorithm = this.algorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        result = result * 59 + (this.includeDistance() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class TransducerAttributesBuilder<DictionaryNode, CandidateType> {
        @SuppressFBWarnings(justification="generated code")
        private int maxDistance;
        @SuppressFBWarnings(justification="generated code")
        private CandidateFactory<CandidateType> candidateFactory;
        @SuppressFBWarnings(justification="generated code")
        private StateTransitionFactory stateTransitionFactory;
        @SuppressFBWarnings(justification="generated code")
        private DistanceFunction minDistance;
        @SuppressFBWarnings(justification="generated code")
        private IFinalFunction<DictionaryNode> isFinal;
        @SuppressFBWarnings(justification="generated code")
        private ITransitionFunction<DictionaryNode> dictionaryTransition;
        @SuppressFBWarnings(justification="generated code")
        private State initialState;
        @SuppressFBWarnings(justification="generated code")
        private DictionaryNode dictionaryRoot;
        @SuppressFBWarnings(justification="generated code")
        private Dawg dictionary;
        @SuppressFBWarnings(justification="generated code")
        private Algorithm algorithm;
        @SuppressFBWarnings(justification="generated code")
        private boolean includeDistance;

        @SuppressFBWarnings(justification="generated code")
        TransducerAttributesBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> maxDistance(int maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> candidateFactory(CandidateFactory<CandidateType> candidateFactory) {
            this.candidateFactory = candidateFactory;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> stateTransitionFactory(StateTransitionFactory stateTransitionFactory) {
            this.stateTransitionFactory = stateTransitionFactory;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> minDistance(DistanceFunction minDistance) {
            this.minDistance = minDistance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> isFinal(IFinalFunction<DictionaryNode> isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> dictionaryTransition(ITransitionFunction<DictionaryNode> dictionaryTransition) {
            this.dictionaryTransition = dictionaryTransition;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> initialState(State initialState) {
            this.initialState = initialState;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> dictionaryRoot(DictionaryNode dictionaryRoot) {
            this.dictionaryRoot = dictionaryRoot;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> dictionary(Dawg dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributesBuilder<DictionaryNode, CandidateType> includeDistance(boolean includeDistance) {
            this.includeDistance = includeDistance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public TransducerAttributes<DictionaryNode, CandidateType> build() {
            return new TransducerAttributes<DictionaryNode, CandidateType>(this.maxDistance, this.candidateFactory, this.stateTransitionFactory, this.minDistance, this.isFinal, this.dictionaryTransition, this.initialState, this.dictionaryRoot, this.dictionary, this.algorithm, this.includeDistance);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "TransducerAttributes.TransducerAttributesBuilder(maxDistance=" + this.maxDistance + ", candidateFactory=" + this.candidateFactory + ", stateTransitionFactory=" + this.stateTransitionFactory + ", minDistance=" + this.minDistance + ", isFinal=" + this.isFinal + ", dictionaryTransition=" + this.dictionaryTransition + ", initialState=" + this.initialState + ", dictionaryRoot=" + this.dictionaryRoot + ", dictionary=" + this.dictionary + ", algorithm=" + (Object)((Object)this.algorithm) + ", includeDistance=" + this.includeDistance + ")";
        }
    }
}

