/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.PositionTransitionFunction;
import com.github.liblevenshtein.transducer.State;

public class TranspositionPositionTransitionFunction
extends PositionTransitionFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public State of(int n, Position position, boolean[] characteristicVector, int offset) {
        int i = position.termIndex();
        int e = position.numErrors();
        boolean t = position.isSpecial();
        int h = i - offset;
        int w = characteristicVector.length;
        if (e == 0 && 0 < n) {
            if (h <= w - 2) {
                int a = n - e < Integer.MAX_VALUE ? n - e + 1 : Integer.MAX_VALUE;
                int b = w - h;
                int k = a < b ? a : b;
                int j = this.indexOf(characteristicVector, k, h);
                switch (j) {
                    case 0: {
                        return this.stateFactory.build(this.positionFactory.build(i + 1, 0, false));
                    }
                    case 1: {
                        return this.stateFactory.build(this.positionFactory.build(i, 1, false), this.positionFactory.build(i, 1, true), this.positionFactory.build(i + 1, 1, false), this.positionFactory.build(i + 2, 1, false));
                    }
                    case -1: {
                        return this.stateFactory.build(this.positionFactory.build(i, 1, false), this.positionFactory.build(i + 1, 1, false));
                    }
                }
                return this.stateFactory.build(this.positionFactory.build(i, 1, false), this.positionFactory.build(i + 1, 1, false), this.positionFactory.build(i + j + 1, j, false));
            }
            if (h == w - 1) {
                if (characteristicVector[h]) {
                    return this.stateFactory.build(this.positionFactory.build(i + 1, 0, false));
                }
                return this.stateFactory.build(this.positionFactory.build(i, 1, false), this.positionFactory.build(i + 1, 1, false));
            }
            return this.stateFactory.build(this.positionFactory.build(i, 1, false));
        }
        if (1 <= e && e < n) {
            if (h <= w - 2) {
                if (!t) {
                    int a = n - e < Integer.MAX_VALUE ? n - e + 1 : Integer.MAX_VALUE;
                    int b = w - h;
                    int k = a < b ? a : b;
                    int j = this.indexOf(characteristicVector, k, h);
                    switch (j) {
                        case 0: {
                            return this.stateFactory.build(this.positionFactory.build(i + 1, e, false));
                        }
                        case 1: {
                            return this.stateFactory.build(this.positionFactory.build(i, e + 1, false), this.positionFactory.build(i, e + 1, true), this.positionFactory.build(i + 1, e + 1, false), this.positionFactory.build(i + 2, e + 1, false));
                        }
                        case -1: {
                            return this.stateFactory.build(this.positionFactory.build(i, e + 1, false), this.positionFactory.build(i + 1, e + 1, false));
                        }
                    }
                    return this.stateFactory.build(this.positionFactory.build(i, e + 1, false), this.positionFactory.build(i + 1, e + 1, false), this.positionFactory.build(i + j + 1, e + j, false));
                }
                if (characteristicVector[h]) {
                    return this.stateFactory.build(this.positionFactory.build(i + 2, e, false));
                }
                return null;
            }
            if (h == w - 1) {
                if (characteristicVector[h]) {
                    return this.stateFactory.build(this.positionFactory.build(i + 1, e, false));
                }
                return this.stateFactory.build(this.positionFactory.build(i, e + 1, false), this.positionFactory.build(i + 1, e + 1, false));
            }
            return this.stateFactory.build(this.positionFactory.build(i, e + 1, false));
        }
        if (h <= w - 1 && !t) {
            if (characteristicVector[h]) {
                return this.stateFactory.build(this.positionFactory.build(i + 1, n, false));
            }
            return null;
        }
        if (h <= w - 2 && t) {
            if (characteristicVector[h]) {
                return this.stateFactory.build(this.positionFactory.build(i + 2, n, false));
            }
            return null;
        }
        return null;
    }
}

