/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer;

import com.github.liblevenshtein.transducer.Position;
import com.github.liblevenshtein.transducer.State;
import com.github.liblevenshtein.transducer.StateIterator;
import com.github.liblevenshtein.transducer.SubsumesFunction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;

public abstract class UnsubsumeFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected SubsumesFunction subsumes;

    public abstract void at(State var1, int var2);

    @SuppressFBWarnings(justification="generated code")
    public UnsubsumeFunction subsumes(SubsumesFunction subsumes) {
        this.subsumes = subsumes;
        return this;
    }

    public static class ForSpecialPositions
    extends UnsubsumeFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public void at(State state, int queryLength) {
            StateIterator outerIter = state.iterator();
            while (outerIter.hasNext()) {
                Position inner;
                Position outer = (Position)outerIter.next();
                int outerErrors = outer.numErrors();
                StateIterator innerIter = outerIter.copy();
                while (innerIter.hasNext() && outerErrors >= (inner = innerIter.peek()).numErrors()) {
                    innerIter.next();
                }
                while (innerIter.hasNext()) {
                    inner = (Position)innerIter.next();
                    if (!this.subsumes.at(outer, inner, queryLength)) continue;
                    innerIter.remove();
                }
            }
        }
    }

    public static class ForStandardPositions
    extends UnsubsumeFunction {
        private static final long serialVersionUID = 1L;

        @Override
        public void at(State state, int queryLength) {
            StateIterator outerIter = state.iterator();
            while (outerIter.hasNext()) {
                Position inner;
                Position outer = (Position)outerIter.next();
                int outerErrors = outer.numErrors();
                StateIterator innerIter = outerIter.copy();
                while (innerIter.hasNext() && outerErrors >= (inner = innerIter.peek()).numErrors()) {
                    innerIter.next();
                }
                while (innerIter.hasNext()) {
                    inner = (Position)innerIter.next();
                    if (!this.subsumes.at(outer, inner, queryLength)) continue;
                    innerIter.remove();
                }
            }
        }
    }
}

