/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer.factory;

import com.github.liblevenshtein.transducer.MergeAndSplitPositionTransitionFunction;
import com.github.liblevenshtein.transducer.PositionTransitionFunction;
import com.github.liblevenshtein.transducer.StandardPositionTransitionFunction;
import com.github.liblevenshtein.transducer.TranspositionPositionTransitionFunction;
import com.github.liblevenshtein.transducer.factory.PositionFactory;
import com.github.liblevenshtein.transducer.factory.StateFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;

public abstract class PositionTransitionFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected StateFactory stateFactory;
    protected PositionFactory positionFactory;

    public abstract PositionTransitionFunction build();

    @SuppressFBWarnings(justification="generated code")
    public PositionTransitionFactory stateFactory(StateFactory stateFactory) {
        this.stateFactory = stateFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public PositionTransitionFactory positionFactory(PositionFactory positionFactory) {
        this.positionFactory = positionFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    protected PositionTransitionFactory() {
    }

    public static class ForMergeAndSplitPositions
    extends PositionTransitionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public PositionTransitionFunction build() {
            return new MergeAndSplitPositionTransitionFunction().stateFactory(this.stateFactory).positionFactory(this.positionFactory);
        }
    }

    public static class ForTranspositionPositions
    extends PositionTransitionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public PositionTransitionFunction build() {
            return new TranspositionPositionTransitionFunction().stateFactory(this.stateFactory).positionFactory(this.positionFactory);
        }
    }

    public static class ForStandardPositions
    extends PositionTransitionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public PositionTransitionFunction build() {
            return new StandardPositionTransitionFunction().stateFactory(this.stateFactory).positionFactory(this.positionFactory);
        }
    }
}

