/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.transducer.factory;

import com.github.liblevenshtein.collection.dictionary.Dawg;
import com.github.liblevenshtein.collection.dictionary.factory.DawgFactory;
import com.github.liblevenshtein.transducer.Algorithm;
import com.github.liblevenshtein.transducer.DistanceFunction;
import com.github.liblevenshtein.transducer.ITransducer;
import com.github.liblevenshtein.transducer.MergeFunction;
import com.github.liblevenshtein.transducer.SpecialPositionComparator;
import com.github.liblevenshtein.transducer.StandardPositionComparator;
import com.github.liblevenshtein.transducer.State;
import com.github.liblevenshtein.transducer.SubsumesFunction;
import com.github.liblevenshtein.transducer.Transducer;
import com.github.liblevenshtein.transducer.TransducerAttributes;
import com.github.liblevenshtein.transducer.UnsubsumeFunction;
import com.github.liblevenshtein.transducer.factory.CandidateFactory;
import com.github.liblevenshtein.transducer.factory.PositionFactory;
import com.github.liblevenshtein.transducer.factory.PositionTransitionFactory;
import com.github.liblevenshtein.transducer.factory.StateFactory;
import com.github.liblevenshtein.transducer.factory.StateTransitionFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransducerBuilder
implements Serializable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TransducerBuilder.class);
    private static final long serialVersionUID = 1L;
    private final DawgFactory dawgFactory = new DawgFactory();
    private Collection<String> dictionary = Collections.EMPTY_LIST;
    private boolean isSorted = false;
    @NonNull
    private Algorithm algorithm = Algorithm.STANDARD;
    private int defaultMaxDistance = 2;
    private boolean includeDistance = true;

    public TransducerBuilder dictionary(@NonNull Collection<String> dictionary, boolean isSorted) {
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary is null");
        }
        this.dictionary = dictionary;
        this.isSorted = isSorted;
        return this;
    }

    public <CandidateType> ITransducer<CandidateType> build() {
        log.info("Building transducer out of [{}] terms with isSorted [{}], algorithm [{}], defaultMaxDistance [{}], and includeDistance [{}]", new Object[]{this.dictionary.size(), this.isSorted, this.algorithm, this.defaultMaxDistance, this.includeDistance});
        Dawg dictionary = this.dawgFactory.build(this.dictionary, this.isSorted);
        PositionFactory positionFactory = new PositionFactory();
        StateFactory stateFactory = new StateFactory();
        PositionTransitionFactory positionTransitionFactory = this.positionTransitionFactory();
        positionTransitionFactory.stateFactory(stateFactory);
        positionTransitionFactory.positionFactory(positionFactory);
        StateTransitionFactory stateTransitionFactory = this.stateTransitionFactory();
        stateTransitionFactory.stateFactory(stateFactory);
        stateTransitionFactory.positionTransitionFactory(positionTransitionFactory);
        State initialState = stateFactory.build(positionFactory.build(0, 0));
        TransducerAttributes attributes = TransducerAttributes.builder().maxDistance(this.defaultMaxDistance).stateTransitionFactory(stateTransitionFactory).candidateFactory(this.candidateFactory()).minDistance(this.minDistance()).isFinal(this.dawgFactory.finalFunction(dictionary)).dictionaryTransition(this.dawgFactory.transitionFunction(dictionary)).dictionaryRoot(dictionary.root()).initialState(initialState).dictionary(dictionary).algorithm(this.algorithm).includeDistance(this.includeDistance).build();
        return new Transducer(attributes);
    }

    protected <CandidateType> CandidateFactory<CandidateType> candidateFactory() {
        return this.includeDistance ? new CandidateFactory.WithDistance() : new CandidateFactory.WithoutDistance();
    }

    protected DistanceFunction minDistance() {
        switch (this.algorithm) {
            case STANDARD: {
                return new DistanceFunction.ForStandardPositions();
            }
            case TRANSPOSITION: 
            case MERGE_AND_SPLIT: {
                return new DistanceFunction.ForSpecialPositions();
            }
        }
        throw new IllegalArgumentException(this.unsupportedAlgorithm(this.algorithm));
    }

    protected PositionTransitionFactory positionTransitionFactory() {
        switch (this.algorithm) {
            case STANDARD: {
                return new PositionTransitionFactory.ForStandardPositions();
            }
            case TRANSPOSITION: {
                return new PositionTransitionFactory.ForTranspositionPositions();
            }
            case MERGE_AND_SPLIT: {
                return new PositionTransitionFactory.ForMergeAndSplitPositions();
            }
        }
        throw new IllegalArgumentException(this.unsupportedAlgorithm(this.algorithm));
    }

    protected StateTransitionFactory stateTransitionFactory() {
        switch (this.algorithm) {
            case STANDARD: {
                return new StateTransitionFactory().comparator(new StandardPositionComparator()).merge(new MergeFunction.ForStandardPositions()).unsubsume(new UnsubsumeFunction.ForStandardPositions().subsumes(new SubsumesFunction.ForStandardAlgorithm()));
            }
            case TRANSPOSITION: {
                return new StateTransitionFactory().comparator(new SpecialPositionComparator()).merge(new MergeFunction.ForSpecialPositions()).unsubsume(new UnsubsumeFunction.ForSpecialPositions().subsumes(new SubsumesFunction.ForTransposition()));
            }
            case MERGE_AND_SPLIT: {
                return new StateTransitionFactory().comparator(new SpecialPositionComparator()).merge(new MergeFunction.ForSpecialPositions()).unsubsume(new UnsubsumeFunction.ForSpecialPositions().subsumes(new SubsumesFunction.ForMergeAndSplit()));
            }
        }
        throw new IllegalArgumentException(this.unsupportedAlgorithm(this.algorithm));
    }

    protected String unsupportedAlgorithm(Algorithm algorithm) {
        return String.format("Unsupported algorithm [%s]", new Object[]{algorithm});
    }

    @SuppressFBWarnings(justification="generated code")
    public TransducerBuilder dictionary(Collection<String> dictionary) {
        this.dictionary = dictionary;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public TransducerBuilder isSorted(boolean isSorted) {
        this.isSorted = isSorted;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public TransducerBuilder algorithm(@NonNull Algorithm algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        this.algorithm = algorithm;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public TransducerBuilder defaultMaxDistance(int defaultMaxDistance) {
        this.defaultMaxDistance = defaultMaxDistance;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public TransducerBuilder includeDistance(boolean includeDistance) {
        this.includeDistance = includeDistance;
        return this;
    }
}

