/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.jdbcdslog.ConfigurationParameters;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.ResultSetLoggingProxy;
import org.jdbcdslog.SlowQueryLogger;
import org.jdbcdslog.StatementLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementLoggingProxy
implements InvocationHandler {
    static Logger logger = LoggerFactory.getLogger(StatementLoggingProxy.class);
    Object targetStatement = null;
    static List executeMethods = Arrays.asList("addBatch", "execute", "executeQuery", "executeUpdate");

    public StatementLoggingProxy(Statement statement) {
        this.targetStatement = statement;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object r = null;
        try {
            boolean toLog = (StatementLogger.isInfoEnabled() || SlowQueryLogger.isInfoEnabled()) && executeMethods.contains(method.getName());
            long t1 = 0L;
            if (toLog) {
                t1 = System.currentTimeMillis();
            }
            if ((r = method.invoke(this.targetStatement, args)) instanceof ResultSet) {
                r = ResultSetLoggingProxy.wrapByResultSetProxy((ResultSet)r);
            }
            if (toLog) {
                long t2 = System.currentTimeMillis();
                StringBuffer sb = LogUtils.createLogEntry(method, args == null ? null : args[0], null, null);
                long time = t2 - t1;
                if (ConfigurationParameters.showTime.booleanValue()) {
                    sb.append(" ").append(t2 - t1).append(" ms.");
                }
                StatementLogger.info(sb.toString());
                if (time >= ConfigurationParameters.slowQueryThreshold) {
                    SlowQueryLogger.info(sb.toString());
                }
            }
        }
        catch (Throwable t) {
            LogUtils.handleException(t, StatementLogger.getLogger(), LogUtils.createLogEntry(method, args[0], null, null));
        }
        return r;
    }
}

