/*
 * Decompiled with CFR 0.152.
 */
package com.starter.issuechecker;

import com.starter.issuechecker.DefaultChecker;
import com.starter.issuechecker.IssueChecker;
import com.starter.issuechecker.resolvers.StatusResolver;
import com.starter.issuechecker.resolvers.github.GithubService;
import com.starter.issuechecker.resolvers.github.GithubStatusResolver;
import com.starter.issuechecker.resolvers.youtrack.YoutrackService;
import com.starter.issuechecker.resolvers.youtrack.YoutrackStatusResolver;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExecutorsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a(\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u000e*\u00020\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0013H\u0002\u00a8\u0006\u0014"}, d2={"createGithub", "Lcom/starter/issuechecker/resolvers/github/GithubStatusResolver;", "config", "Lcom/starter/issuechecker/IssueChecker$Config;", "createYoutrack", "Lcom/starter/issuechecker/resolvers/youtrack/YoutrackStatusResolver;", "defaultChecker", "Lcom/starter/issuechecker/DefaultChecker;", "restApi", "Lretrofit2/Retrofit;", "kotlin.jvm.PlatformType", "baseUrl", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "executor", "Ljava/util/concurrent/Executor;", "githubOkHttpClient", "auth", "Lkotlin/Function0;", "issuechecker"})
public final class DiKt {
    @NotNull
    public static final DefaultChecker defaultChecker(@NotNull IssueChecker.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object[] objectArray = new StatusResolver[]{DiKt.createGithub(config), DiKt.createYoutrack(config)};
        Set supportedTrackers = SetsKt.setOf((Object[])objectArray);
        return new DefaultChecker(supportedTrackers, ExecutorsKt.from((Executor)config.getExecutor()));
    }

    public static final Retrofit restApi(@NotNull String baseUrl, @NotNull OkHttpClient okHttpClient, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).callbackExecutor(executor).client(okHttpClient).build();
    }

    private static final YoutrackStatusResolver createYoutrack(IssueChecker.Config config) {
        Object object = DiKt.restApi("https://youtrack.jetbrains.com/", config.getOkHttpClient(), config.getExecutor()).create(YoutrackService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"restApi(\n        baseUrl = \"https://youtrack.jetbrains.com/\",\n        okHttpClient = config.okHttpClient,\n        executor = config.executor,\n    ).create(YoutrackService::class.java)");
        return new YoutrackStatusResolver((YoutrackService)object);
    }

    private static final GithubStatusResolver createGithub(IssueChecker.Config config) {
        Object object = DiKt.restApi("https://api.github.com/", DiKt.githubOkHttpClient(config.getOkHttpClient(), (Function0<String>)((Function0)new Function0<String>(config){
            final /* synthetic */ IssueChecker.Config $config;
            {
                this.$config = $config;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$config.getGithubToken();
            }
        })), config.getExecutor()).create(GithubService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"config: IssueChecker.Config,\n) = GithubStatusResolver(\n    service = restApi(\n        baseUrl = \"https://api.github.com/\",\n        okHttpClient = config.okHttpClient.githubOkHttpClient { config.githubToken },\n        executor = config.executor,\n    ).create(GithubService::class.java)");
        return new GithubStatusResolver((GithubService)object);
    }

    private static final OkHttpClient githubOkHttpClient(OkHttpClient $this$githubOkHttpClient, Function0<String> auth) {
        OkHttpClient.Builder this_$iv = $this$githubOkHttpClient.newBuilder();
        boolean bl = false;
        return this_$iv.addInterceptor(new Interceptor(auth){
            final /* synthetic */ Function0 $auth$inlined;
            {
                this.$auth$inlined = function0;
            }

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Request request;
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                String string = (String)this.$auth$inlined.invoke();
                if (string == null) {
                    request = null;
                } else {
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String token = string2;
                    boolean bl4 = false;
                    request = chain2.request().newBuilder().addHeader("Authorization", Intrinsics.stringPlus((String)"token ", (Object)token)).build();
                }
                Request request2 = request;
                Request newRequest = request2 == null ? chain2.request() : request2;
                return chain2.proceed(newRequest);
            }
        }).build();
    }
}

