/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebPEncoderOptions;
import com.luciad.imageio.webp.WebPWrapper;
import com.luciad.imageio.webp.WebPWriteParam;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J$\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/luciad/imageio/webp/WebPWriter;", "Ljavax/imageio/ImageWriter;", "originatingProvider", "Ljavax/imageio/spi/ImageWriterSpi;", "<init>", "(Ljavax/imageio/spi/ImageWriterSpi;)V", "getDefaultWriteParam", "Lcom/luciad/imageio/webp/WebPWriteParam;", "convertImageMetadata", "Ljavax/imageio/metadata/IIOMetadata;", "inData", "imageType", "Ljavax/imageio/ImageTypeSpecifier;", "param", "Ljavax/imageio/ImageWriteParam;", "convertStreamMetadata", "getDefaultImageMetadata", "getDefaultStreamMetadata", "write", "", "streamMetadata", "image", "Ljavax/imageio/IIOImage;", "Companion", "webp-imageio"})
public final class WebPWriter
extends ImageWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WebPWriter(@Nullable ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    @NotNull
    public WebPWriteParam getDefaultWriteParam() {
        return new WebPWriteParam(this.getLocale());
    }

    @Override
    @Nullable
    public IIOMetadata convertImageMetadata(@Nullable IIOMetadata inData, @NotNull ImageTypeSpecifier imageType, @Nullable ImageWriteParam param) {
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        return null;
    }

    @Override
    @Nullable
    public IIOMetadata convertStreamMetadata(@Nullable IIOMetadata inData, @Nullable ImageWriteParam param) {
        return null;
    }

    @Override
    @Nullable
    public IIOMetadata getDefaultImageMetadata(@NotNull ImageTypeSpecifier imageType, @Nullable ImageWriteParam param) {
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        return null;
    }

    @Override
    @Nullable
    public IIOMetadata getDefaultStreamMetadata(@Nullable ImageWriteParam param) {
        return null;
    }

    @Override
    public void write(@Nullable IIOMetadata streamMetadata, @NotNull IIOImage image, @Nullable ImageWriteParam param) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        WebPWriteParam webPWriteParam = param instanceof WebPWriteParam ? (WebPWriteParam)param : null;
        if (webPWriteParam == null) {
            webPWriteParam = this.getDefaultWriteParam();
        }
        WebPWriteParam writeParam = webPWriteParam;
        Object object = this.getOutput();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.imageio.stream.ImageOutputStream");
        ImageOutputStream output = (ImageOutputStream)object;
        RenderedImage ri = image.getRenderedImage();
        WebPEncoderOptions webPEncoderOptions = writeParam.getEncoderOptions$webp_imageio();
        Intrinsics.checkNotNull((Object)ri);
        byte[] encodedData = WebPWriter.Companion.encode(webPEncoderOptions, ri);
        output.write(encodedData);
        output.flush();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH\u0002J0\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH\u0002J0\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010 \u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010!\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001dH\u0002\u00a8\u0006\""}, d2={"Lcom/luciad/imageio/webp/WebPWriter$Companion;", "", "<init>", "()V", "encode", "", "options", "Lcom/luciad/imageio/webp/WebPEncoderOptions;", "image", "Ljava/awt/image/RenderedImage;", "hasTranslucency", "", "aRi", "getShift", "", "aMask", "getRGB", "extractDirectRGBInt", "aWidth", "aHeight", "aColorModel", "Ljava/awt/image/DirectColorModel;", "aSampleModel", "Ljava/awt/image/SinglePixelPackedSampleModel;", "aDataBuffer", "Ljava/awt/image/DataBufferInt;", "extractComponentRGBInt", "Ljava/awt/image/ComponentSampleModel;", "extractComponentRGBByte", "Ljava/awt/image/DataBufferByte;", "getRGBA", "extractDirectRGBAInt", "extractComponentRGBAInt", "extractComponentRGBAByte", "webp-imageio"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] encode(WebPEncoderOptions options, RenderedImage image) {
            byte[] byArray;
            boolean encodeAlpha = this.hasTranslucency(image);
            if (encodeAlpha) {
                byte[] rgbaData = this.getRGBA(image);
                byArray = WebPWrapper.INSTANCE.encodeRGBA(options, rgbaData, image.getWidth(), image.getHeight(), image.getWidth() * 4);
            } else {
                byte[] rgbData = this.getRGB(image);
                byArray = WebPWrapper.INSTANCE.encodeRGB(options, rgbData, image.getWidth(), image.getHeight(), image.getWidth() * 3);
            }
            return byArray;
        }

        private final boolean hasTranslucency(RenderedImage aRi) {
            return aRi.getColorModel().hasAlpha();
        }

        private final int getShift(int aMask) {
            int shift = 0;
            while ((aMask >> shift & 1) == 0) {
                ++shift;
            }
            return shift;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final byte[] getRGB(RenderedImage aRi) {
            byte[] byArray;
            int width = aRi.getWidth();
            int height = aRi.getHeight();
            ColorModel colorModel = aRi.getColorModel();
            ColorSpace colorSpace = colorModel.getColorSpace();
            if (colorSpace.isCS_sRGB() && colorModel instanceof ComponentColorModel) {
                SampleModel sampleModel = aRi.getSampleModel();
                Intrinsics.checkNotNull((Object)sampleModel, (String)"null cannot be cast to non-null type java.awt.image.ComponentSampleModel");
                ComponentSampleModel sampleModel2 = (ComponentSampleModel)sampleModel;
                switch (sampleModel2.getTransferType()) {
                    case 0: {
                        DataBuffer dataBuffer = aRi.getData().getDataBuffer();
                        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
                        byArray = this.extractComponentRGBByte(width, height, sampleModel2, (DataBufferByte)dataBuffer);
                        return byArray;
                    }
                    case 3: {
                        DataBuffer dataBuffer = aRi.getData().getDataBuffer();
                        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                        byArray = this.extractComponentRGBInt(width, height, sampleModel2, (DataBufferInt)dataBuffer);
                        return byArray;
                    }
                    default: {
                        throw new IOException("Incompatible image: " + aRi);
                    }
                }
            }
            if (colorSpace.isCS_sRGB() && colorModel instanceof DirectColorModel) {
                SampleModel sampleModel = aRi.getSampleModel();
                Intrinsics.checkNotNull((Object)sampleModel, (String)"null cannot be cast to non-null type java.awt.image.SinglePixelPackedSampleModel");
                SinglePixelPackedSampleModel sampleModel3 = (SinglePixelPackedSampleModel)sampleModel;
                int type = sampleModel3.getTransferType();
                if (type != 3) throw new IOException("Incompatible image: " + aRi);
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                DataBuffer dataBuffer = aRi.getData().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                byArray = this.extractDirectRGBInt(width, height, directColorModel, sampleModel3, (DataBufferInt)dataBuffer);
                return byArray;
            } else {
                BufferedImage i = new BufferedImage(aRi.getWidth(), aRi.getHeight(), 1);
                Graphics2D g = i.createGraphics();
                g.drawRenderedImage(aRi, new AffineTransform());
                g.dispose();
                byArray = this.getRGB(i);
            }
            return byArray;
        }

        private final byte[] extractDirectRGBInt(int aWidth, int aHeight, DirectColorModel aColorModel, SinglePixelPackedSampleModel aSampleModel, DataBufferInt aDataBuffer) {
            byte[] out = new byte[aWidth * aHeight * 3];
            int rMask = aColorModel.getRedMask();
            int gMask = aColorModel.getGreenMask();
            int bMask = aColorModel.getBlueMask();
            int rShift = this.getShift(rMask);
            int gShift = this.getShift(gMask);
            int bShift = this.getShift(bMask);
            int[] bank = aDataBuffer.getBankData()[0];
            int scanlineStride = aSampleModel.getScanlineStride();
            int scanIx = 0;
            int b = 0;
            for (int y = 0; y < aHeight; ++y) {
                int pixIx = scanIx;
                int x = 0;
                while (x < aWidth) {
                    int pixel = bank[pixIx++];
                    out[b] = (byte)((pixel & rMask) >>> rShift);
                    out[b + 1] = (byte)((pixel & gMask) >>> gShift);
                    out[b + 2] = (byte)((pixel & bMask) >>> bShift);
                    ++x;
                    b += 3;
                }
                scanIx += scanlineStride;
            }
            return out;
        }

        private final byte[] extractComponentRGBInt(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferInt aDataBuffer) {
            byte[] out = new byte[aWidth * aHeight * 3];
            int[] bankIndices = aSampleModel.getBankIndices();
            int[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
            int[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
            int[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
            int[] bankOffsets = aSampleModel.getBandOffsets();
            int rScanIx = bankOffsets[0];
            int gScanIx = bankOffsets[1];
            int bScanIx = bankOffsets[2];
            int pixelStride = aSampleModel.getPixelStride();
            int scanlineStride = aSampleModel.getScanlineStride();
            int b = 0;
            for (int y = 0; y < aHeight; ++y) {
                int rPixIx = rScanIx;
                int gPixIx = gScanIx;
                int bPixIx = bScanIx;
                int x = 0;
                while (x < aWidth) {
                    out[b] = (byte)rBank[rPixIx];
                    rPixIx += pixelStride;
                    out[b + 1] = (byte)gBank[gPixIx];
                    gPixIx += pixelStride;
                    out[b + 2] = (byte)bBank[bPixIx];
                    bPixIx += pixelStride;
                    ++x;
                    b += 3;
                }
                rScanIx += scanlineStride;
                gScanIx += scanlineStride;
                bScanIx += scanlineStride;
            }
            return out;
        }

        private final byte[] extractComponentRGBByte(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferByte aDataBuffer) {
            byte[] out = new byte[aWidth * aHeight * 3];
            int[] bankIndices = aSampleModel.getBankIndices();
            byte[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
            byte[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
            byte[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
            int[] bankOffsets = aSampleModel.getBandOffsets();
            int rScanIx = bankOffsets[0];
            int gScanIx = bankOffsets[1];
            int bScanIx = bankOffsets[2];
            int pixelStride = aSampleModel.getPixelStride();
            int scanlineStride = aSampleModel.getScanlineStride();
            int b = 0;
            for (int y = 0; y < aHeight; ++y) {
                int rPixIx = rScanIx;
                int gPixIx = gScanIx;
                int bPixIx = bScanIx;
                int x = 0;
                while (x < aWidth) {
                    out[b] = rBank[rPixIx];
                    rPixIx += pixelStride;
                    out[b + 1] = gBank[gPixIx];
                    gPixIx += pixelStride;
                    out[b + 2] = bBank[bPixIx];
                    bPixIx += pixelStride;
                    ++x;
                    b += 3;
                }
                rScanIx += scanlineStride;
                gScanIx += scanlineStride;
                bScanIx += scanlineStride;
            }
            return out;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final byte[] getRGBA(RenderedImage aRi) {
            byte[] byArray;
            int width = aRi.getWidth();
            int height = aRi.getHeight();
            ColorModel colorModel = aRi.getColorModel();
            if (colorModel instanceof ComponentColorModel) {
                SampleModel sampleModel = aRi.getSampleModel();
                Intrinsics.checkNotNull((Object)sampleModel, (String)"null cannot be cast to non-null type java.awt.image.ComponentSampleModel");
                ComponentSampleModel sampleModel2 = (ComponentSampleModel)sampleModel;
                switch (sampleModel2.getTransferType()) {
                    case 0: {
                        DataBuffer dataBuffer = aRi.getData().getDataBuffer();
                        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
                        byArray = this.extractComponentRGBAByte(width, height, sampleModel2, (DataBufferByte)dataBuffer);
                        return byArray;
                    }
                    case 3: {
                        DataBuffer dataBuffer = aRi.getData().getDataBuffer();
                        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                        byArray = this.extractComponentRGBAInt(width, height, sampleModel2, (DataBufferInt)dataBuffer);
                        return byArray;
                    }
                    default: {
                        throw new IOException("Incompatible image: " + aRi);
                    }
                }
            }
            if (colorModel instanceof DirectColorModel) {
                SampleModel sampleModel = aRi.getSampleModel();
                Intrinsics.checkNotNull((Object)sampleModel, (String)"null cannot be cast to non-null type java.awt.image.SinglePixelPackedSampleModel");
                SinglePixelPackedSampleModel sampleModel3 = (SinglePixelPackedSampleModel)sampleModel;
                int type = sampleModel3.getTransferType();
                if (type != 3) throw new IOException("Incompatible image: " + aRi);
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                DataBuffer dataBuffer = aRi.getData().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                byArray = this.extractDirectRGBAInt(width, height, directColorModel, sampleModel3, (DataBufferInt)dataBuffer);
                return byArray;
            } else {
                BufferedImage i = new BufferedImage(aRi.getWidth(), aRi.getHeight(), 2);
                Graphics2D g = i.createGraphics();
                g.drawRenderedImage(aRi, new AffineTransform());
                g.dispose();
                byArray = this.getRGBA(i);
            }
            return byArray;
        }

        private final byte[] extractDirectRGBAInt(int aWidth, int aHeight, DirectColorModel aColorModel, SinglePixelPackedSampleModel aSampleModel, DataBufferInt aDataBuffer) {
            byte[] out = new byte[aWidth * aHeight * 4];
            int rMask = aColorModel.getRedMask();
            int gMask = aColorModel.getGreenMask();
            int bMask = aColorModel.getBlueMask();
            int aMask = aColorModel.getAlphaMask();
            int rShift = this.getShift(rMask);
            int gShift = this.getShift(gMask);
            int bShift = this.getShift(bMask);
            int aShift = this.getShift(aMask);
            int[] bank = aDataBuffer.getBankData()[0];
            int scanlineStride = aSampleModel.getScanlineStride();
            int scanIx = 0;
            int b = 0;
            for (int y = 0; y < aHeight; ++y) {
                int pixIx = scanIx;
                int x = 0;
                while (x < aWidth) {
                    int pixel = bank[pixIx++];
                    out[b] = (byte)((pixel & rMask) >>> rShift);
                    out[b + 1] = (byte)((pixel & gMask) >>> gShift);
                    out[b + 2] = (byte)((pixel & bMask) >>> bShift);
                    out[b + 3] = (byte)((pixel & aMask) >>> aShift);
                    ++x;
                    b += 4;
                }
                scanIx += scanlineStride;
            }
            return out;
        }

        private final byte[] extractComponentRGBAInt(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferInt aDataBuffer) {
            byte[] out = new byte[aWidth * aHeight * 4];
            int[] bankIndices = aSampleModel.getBankIndices();
            int[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
            int[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
            int[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
            int[] aBank = aDataBuffer.getBankData()[bankIndices[3]];
            int[] bankOffsets = aSampleModel.getBandOffsets();
            int rScanIx = bankOffsets[0];
            int gScanIx = bankOffsets[1];
            int bScanIx = bankOffsets[2];
            int aScanIx = bankOffsets[3];
            int pixelStride = aSampleModel.getPixelStride();
            int scanlineStride = aSampleModel.getScanlineStride();
            int b = 0;
            for (int y = 0; y < aHeight; ++y) {
                int rPixIx = rScanIx;
                int gPixIx = gScanIx;
                int bPixIx = bScanIx;
                int aPixIx = aScanIx;
                int x = 0;
                while (x < aWidth) {
                    out[b] = (byte)rBank[rPixIx];
                    rPixIx += pixelStride;
                    out[b + 1] = (byte)gBank[gPixIx];
                    gPixIx += pixelStride;
                    out[b + 2] = (byte)bBank[bPixIx];
                    bPixIx += pixelStride;
                    out[b + 3] = (byte)aBank[aPixIx];
                    aPixIx += pixelStride;
                    ++x;
                    b += 4;
                }
                rScanIx += scanlineStride;
                gScanIx += scanlineStride;
                bScanIx += scanlineStride;
                aScanIx += scanlineStride;
            }
            return out;
        }

        private final byte[] extractComponentRGBAByte(int aWidth, int aHeight, ComponentSampleModel aSampleModel, DataBufferByte aDataBuffer) {
            byte[] out = new byte[aWidth * aHeight * 4];
            int[] bankIndices = aSampleModel.getBankIndices();
            byte[] rBank = aDataBuffer.getBankData()[bankIndices[0]];
            byte[] gBank = aDataBuffer.getBankData()[bankIndices[1]];
            byte[] bBank = aDataBuffer.getBankData()[bankIndices[2]];
            byte[] aBank = aDataBuffer.getBankData()[bankIndices[3]];
            int[] bankOffsets = aSampleModel.getBandOffsets();
            int rScanIx = bankOffsets[0];
            int gScanIx = bankOffsets[1];
            int bScanIx = bankOffsets[2];
            int aScanIx = bankOffsets[3];
            int pixelStride = aSampleModel.getPixelStride();
            int scanlineStride = aSampleModel.getScanlineStride();
            int b = 0;
            for (int y = 0; y < aHeight; ++y) {
                int rPixIx = rScanIx;
                int gPixIx = gScanIx;
                int bPixIx = bScanIx;
                int aPixIx = aScanIx;
                int x = 0;
                while (x < aWidth) {
                    out[b] = rBank[rPixIx];
                    rPixIx += pixelStride;
                    out[b + 1] = gBank[gPixIx];
                    gPixIx += pixelStride;
                    out[b + 2] = bBank[bPixIx];
                    bPixIx += pixelStride;
                    out[b + 3] = aBank[aPixIx];
                    aPixIx += pixelStride;
                    ++x;
                    b += 4;
                }
                rScanIx += scanlineStride;
                gScanIx += scanlineStride;
                bScanIx += scanlineStride;
                aScanIx += scanlineStride;
            }
            return out;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

