/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebPReadParam;
import com.luciad.imageio.webp.WebPWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u001e\u0010\u001d\u001a\u0010\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f0\u001e2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/luciad/imageio/webp/WebPReader;", "Ljavax/imageio/ImageReader;", "originatingProvider", "Ljavax/imageio/spi/ImageReaderSpi;", "<init>", "(Ljavax/imageio/spi/ImageReaderSpi;)V", "cachedData", "", "cachedHeader", "Lkotlin/Pair;", "", "setInput", "", "input", "", "seekForwardOnly", "", "ignoreMetadata", "getNumImages", "allowSearch", "readHeader", "readData", "checkIndex", "imageIndex", "getWidth", "getHeight", "getStreamMetadata", "Ljavax/imageio/metadata/IIOMetadata;", "getImageMetadata", "getImageTypes", "", "Ljavax/imageio/ImageTypeSpecifier;", "kotlin.jvm.PlatformType", "getDefaultReadParam", "Lcom/luciad/imageio/webp/WebPReadParam;", "read", "Ljava/awt/image/BufferedImage;", "param", "Ljavax/imageio/ImageReadParam;", "webp-imageio"})
@SourceDebugExtension(value={"SMAP\nWebPReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPReader.kt\ncom/luciad/imageio/webp/WebPReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class WebPReader
extends ImageReader {
    @Nullable
    private byte[] cachedData;
    @Nullable
    private Pair<Integer, Integer> cachedHeader;

    public WebPReader(@NotNull ImageReaderSpi originatingProvider) {
        Intrinsics.checkNotNullParameter((Object)originatingProvider, (String)"originatingProvider");
        super(originatingProvider);
    }

    @Override
    public void setInput(@NotNull Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.cachedData = null;
        this.cachedHeader = null;
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        return 1;
    }

    private final Pair<Integer, Integer> readHeader() {
        Pair<Integer, Integer> pair = this.cachedHeader;
        if (pair != null) {
            Pair<Integer, Integer> it = pair;
            boolean bl = false;
            return it;
        }
        byte[] data = this.readData();
        int[] nArray = WebPWrapper.INSTANCE.getInfo(data, 0, data.length);
        int width = nArray[0];
        int height = nArray[1];
        return TuplesKt.to((Object)width, (Object)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] readData() {
        Object object;
        Object object2;
        byte[] byArray = this.cachedData;
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            return it;
        }
        Object object3 = this.getInput();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type javax.imageio.stream.ImageInputStream");
        ImageInputStream input = (ImageInputStream)object3;
        long length = input.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Cannot read image of size " + length);
        }
        if (input.getStreamPosition() != 0L) {
            if (this.isSeekForwardOnly()) {
                throw new IOException();
            }
            input.seek(0L);
        }
        if (length > 0L) {
            byte[] p0 = object2 = new byte[(int)length];
            boolean bl = false;
            input.readFully(p0);
            object = object2;
        } else {
            object2 = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream out = (ByteArrayOutputStream)object2;
                boolean bl = false;
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while (true) {
                    int n;
                    int it = n = input.read(buffer);
                    boolean bl2 = false;
                    bytesRead = it;
                    if (n == -1) break;
                    out.write(buffer, 0, bytesRead);
                }
                byte[] byArray2 = out.toByteArray();
                object = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        Object data = object;
        this.cachedData = data;
        Intrinsics.checkNotNull((Object)data);
        return data;
    }

    private final void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("Invalid image index");
        }
    }

    @Override
    public int getWidth(int imageIndex) {
        this.checkIndex(imageIndex);
        int width = ((Number)this.readHeader().component1()).intValue();
        return width;
    }

    @Override
    public int getHeight(int imageIndex) {
        this.checkIndex(imageIndex);
        int height = ((Number)this.readHeader().component2()).intValue();
        return height;
    }

    @Override
    @Nullable
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    @Nullable
    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    @Override
    @NotNull
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) {
        return CollectionsKt.listOf((Object)ImageTypeSpecifier.createFromBufferedImageType(2)).iterator();
    }

    @Override
    @NotNull
    public WebPReadParam getDefaultReadParam() {
        return new WebPReadParam();
    }

    @Override
    @NotNull
    public BufferedImage read(int imageIndex, @Nullable ImageReadParam param) {
        this.checkIndex(imageIndex);
        byte[] data = this.readData();
        this.readHeader();
        WebPReadParam webPReadParam = param instanceof WebPReadParam ? (WebPReadParam)param : null;
        if (webPReadParam == null) {
            webPReadParam = this.getDefaultReadParam();
        }
        WebPReadParam readParam = webPReadParam;
        int[] outParams = new int[4];
        int[] pixels = WebPWrapper.INSTANCE.decode(readParam.getDecoderOptions$webp_imageio(), data, 0, data.length, outParams);
        int width = outParams[1];
        int height = outParams[2];
        boolean alpha = outParams[3] != 0;
        DirectColorModel colorModel = alpha ? new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216) : new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(width, height);
        DataBufferInt db = new DataBufferInt(pixels, width * height);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, db, null);
        return new BufferedImage(colorModel, raster, false, new Hashtable());
    }
}

