/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp.internal;

import com.luciad.imageio.webp.internal.JavaUtilsKt;
import com.luciad.imageio.webp.internal.OsInfo;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\r\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR!\u0010\u001b\u001a\u00020\u00148FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcom/luciad/imageio/webp/internal/NativeLoader;", "", "<init>", "()V", "extracted", "", "initialize", "tempDir", "Ljava/io/File;", "getTempDir", "()Ljava/io/File;", "cleanup", "", "cleanup$webp_imageio", "contentsEquals", "in1", "Ljava/io/InputStream;", "in2", "extractAndLoadLibraryFile", "libFolderForCurrentOS", "", "libraryFileName", "targetFolder", "loadNativeLibrary", "path", "name", "hasResource", "version", "getVersion$annotations", "getVersion", "()Ljava/lang/String;", "version$delegate", "Lkotlin/Lazy;", "webp-imageio"})
@SourceDebugExtension(value={"SMAP\nNativeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLoader.kt\ncom/luciad/imageio/webp/internal/NativeLoader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n13472#2,2:257\n1#3:259\n739#4,9:260\n*S KotlinDebug\n*F\n+ 1 NativeLoader.kt\ncom/luciad/imageio/webp/internal/NativeLoader\n*L\n83#1:257,2\n214#1:260,9\n*E\n"})
public final class NativeLoader {
    @NotNull
    public static final NativeLoader INSTANCE = new NativeLoader();
    private static boolean extracted;
    @NotNull
    private static final Lazy version$delegate;

    private NativeLoader() {
    }

    @JvmStatic
    public static final synchronized boolean initialize() {
        if (!extracted) {
            INSTANCE.cleanup$webp_imageio();
        }
        INSTANCE.loadNativeLibrary();
        return extracted;
    }

    private final File getTempDir() {
        String string = JavaUtilsKt.findProperty("com.luciad.imageio.webp.tmpdir");
        if (string == null && (string = JavaUtilsKt.findProperty("java.io.tmpdir")) == null) {
            throw new IllegalStateException("Neither `com.luciad.imageio.webp.tmpdir` nor `java.io.tmpdir` was found.".toString());
        }
        return new File(string);
    }

    @JvmStatic
    public static final void cleanup$webp_imageio() {
        String tempFolder = INSTANCE.getTempDir().getAbsolutePath();
        File dir = new File(tempFolder);
        File[] fileArray = dir.listFiles(NativeLoader::cleanup$lambda$0);
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File nativeLibFile = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                File lckFile = new File(nativeLibFile.getAbsolutePath() + ".lck");
                if (lckFile.exists()) continue;
                try {
                    nativeLibFile.delete();
                    continue;
                }
                catch (SecurityException e) {
                    System.err.println("Failed to delete old native lib " + e.getMessage());
                }
            }
        }
    }

    private final boolean contentsEquals(InputStream in1, InputStream in2) {
        int ch2;
        BufferedInputStream input1 = in1 instanceof BufferedInputStream ? (BufferedInputStream)in1 : new BufferedInputStream(in1);
        BufferedInputStream input2 = in2 instanceof BufferedInputStream ? (BufferedInputStream)in2 : new BufferedInputStream(in2);
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        boolean bl;
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uuid = string;
        String extractedLibFileName = "webp-imageio-" + NativeLoader.getVersion() + "-" + uuid + "-" + libraryFileName;
        String extractedLckFileName = extractedLibFileName + ".lck";
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        File extractedLckFile = new File(targetFolder, extractedLckFileName);
        try {
            Throwable throwable;
            Closeable closeable;
            Object p0 = NativeLoader.class.getResourceAsStream(nativeLibraryFilePath);
            boolean bl2 = false;
            InputStream inputStream = p0;
            if (inputStream == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Closeable closeable2 = inputStream;
            p0 = null;
            try {
                long writer22;
                InputStream reader22 = (InputStream)closeable2;
                boolean bl3 = false;
                if (!extractedLckFile.exists()) {
                    new FileOutputStream(extractedLckFile).close();
                }
                closeable = new FileOutputStream(extractedLibFile);
                throwable = null;
                try {
                    FileOutputStream writer22 = (FileOutputStream)closeable;
                    boolean bl4 = false;
                    writer22 = ByteStreamsKt.copyTo$default((InputStream)reader22, (OutputStream)writer22, (int)0, (int)2, null);
                }
                catch (Throwable bl4) {
                    throwable = bl4;
                    throw bl4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                long reader22 = writer22;
            }
            catch (Throwable bl3) {
                p0 = bl3;
                throw bl3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)p0);
            }
            extractedLibFile.deleteOnExit();
            extractedLckFile.deleteOnExit();
            extractedLibFile.setReadable(true);
            extractedLibFile.setWritable(true, true);
            extractedLibFile.setExecutable(true);
            p0 = NativeLoader.class.getResourceAsStream(nativeLibraryFilePath);
            boolean bl5 = false;
            Object object = p0;
            if (object == null) {
                String bl3 = "Required value was null.";
                throw new IllegalStateException(bl3.toString());
            }
            closeable2 = (Closeable)object;
            p0 = null;
            try {
                InputStream nativeIn = (InputStream)closeable2;
                boolean bl6 = false;
                closeable = new FileInputStream(extractedLibFile);
                throwable = null;
                try {
                    FileInputStream extractedLibIn = (FileInputStream)closeable;
                    boolean bl7 = false;
                    if (!INSTANCE.contentsEquals(nativeIn, extractedLibIn)) {
                        throw new IllegalStateException(("Failed to write a native library file at " + extractedLibFile).toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                p0 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)p0);
            }
            bl = this.loadNativeLibrary(targetFolder, extractedLibFileName);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean loadNativeLibrary(String path, String name) {
        boolean bl;
        File libPath = new File(path, name);
        if (libPath.exists()) {
            boolean bl2;
            try {
                System.load(new File(path, name).getAbsolutePath());
                bl2 = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Failed to load native library:" + name + ". osinfo:" + OsInfo.getNativeLibFolderPathForCurrentOS());
                System.err.println(e);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadNativeLibrary() {
        List list;
        void $this$dropLastWhile$iv;
        String string;
        if (extracted) {
            return;
        }
        List triedPaths = new ArrayList();
        String nativeLibraryName = System.mapLibraryName("webp-imageio");
        String nativeLibraryPath = "/native/" + OsInfo.getNativeLibFolderPathForCurrentOS();
        boolean hasNativeLib = this.hasResource(nativeLibraryPath + "/" + nativeLibraryName);
        if (hasNativeLib) {
            String tempFolder = this.getTempDir().getAbsolutePath();
            Intrinsics.checkNotNull((Object)nativeLibraryName);
            Intrinsics.checkNotNull((Object)tempFolder);
            if (this.extractAndLoadLibraryFile(nativeLibraryPath, nativeLibraryName, tempFolder)) {
                extracted = true;
                return;
            }
            triedPaths.add(nativeLibraryPath);
        }
        if ((string = JavaUtilsKt.findProperty("java.library.path")) == null) {
            string = "";
        }
        String javaLibraryPath = string;
        Object object = javaLibraryPath;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
        String string3 = string2;
        string3 = new Regex(string3);
        int n = 0;
        object = string3.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String p0 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)p0).length() == 0) continue;
                list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        for (String ldPath : list) {
            if (((CharSequence)ldPath).length() == 0) continue;
            Intrinsics.checkNotNull((Object)nativeLibraryName);
            if (this.loadNativeLibrary(ldPath, nativeLibraryName)) {
                extracted = true;
                return;
            }
            triedPaths.add(ldPath);
        }
        extracted = false;
        String string4 = OsInfo.getOSName();
        String string5 = OsInfo.getArchName();
        Iterable iterable = triedPaths;
        String string6 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"pathSeparator");
        String string7 = "No native library found for os.name=" + string4 + ", os.arch=" + string5 + ", paths=[" + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string6, null, null, (int)0, null, null, (int)62, null) + "]";
        throw new IllegalStateException(string7.toString());
    }

    private final boolean hasResource(String path) {
        return NativeLoader.class.getResource(path) != null;
    }

    @NotNull
    public static final String getVersion() {
        Lazy lazy = version$delegate;
        return (String)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getVersion$annotations() {
    }

    private static final boolean cleanup$lambda$0(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.startsWith$default((String)name, (String)("webp-imageio-" + NativeLoader.getVersion()), (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)".lck", (boolean)false, (int)2, null);
    }

    private static final String version_delegate$lambda$9() {
        String string;
        String string2;
        try {
            String string3;
            URL versionFile = NativeLoader.class.getClassLoader().getResource("webp-imageio.properties");
            if (versionFile != null) {
                Object object = new Properties();
                Properties $this$version_delegate_u24lambda_u249_u24lambda_u248 = object;
                boolean bl = false;
                $this$version_delegate_u24lambda_u249_u24lambda_u248.load(versionFile.openStream());
                Properties versionData = object;
                String string4 = versionData.getProperty("webp_imageio_version", null);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
                object = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                Regex regex = new Regex("[^0-9.]");
                String string5 = "";
                string3 = regex.replace((CharSequence)object, string5);
            } else {
                string3 = null;
            }
            string2 = string3;
        }
        catch (IOException e) {
            System.err.println(e);
            string2 = null;
        }
        if ((string = string2) == null) {
            string = "unknown";
        }
        return string;
    }

    static {
        version$delegate = LazyKt.lazy(NativeLoader::version_delegate$lambda$9);
    }
}

