/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebP;
import com.luciad.imageio.webp.WebPDecoderOptions;
import com.luciad.imageio.webp.WebPEncoderOptions;
import com.luciad.imageio.webp.internal.NativeLoader;
import com.luciad.imageio.webp.internal.VP8StatusCode;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nJ.\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J.\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/luciad/imageio/webp/WebPWrapper;", "", "()V", "NATIVE_LIBRARY_LOADED", "", "cleaner", "Ljava/lang/ref/Cleaner;", "getCleaner", "()Ljava/lang/ref/Cleaner;", "decode", "", "options", "Lcom/luciad/imageio/webp/WebPDecoderOptions;", "data", "", "offset", "", "length", "out", "encodeRGB", "Lcom/luciad/imageio/webp/WebPEncoderOptions;", "rgbaData", "width", "height", "stride", "encodeRGBA", "getInfo", "loadNativeLibrary", "", "webp-imageio"})
@SourceDebugExtension(value={"SMAP\nWebPWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPWrapper.kt\ncom/luciad/imageio/webp/WebPWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class WebPWrapper {
    @NotNull
    public static final WebPWrapper INSTANCE = new WebPWrapper();
    private static boolean NATIVE_LIBRARY_LOADED;
    @NotNull
    private static final Cleaner cleaner;

    private WebPWrapper() {
    }

    @NotNull
    public final Cleaner getCleaner() {
        return cleaner;
    }

    @JvmStatic
    public static final synchronized void loadNativeLibrary() {
        if (!NATIVE_LIBRARY_LOADED) {
            Object object;
            Object object2 = INSTANCE;
            try {
                WebPWrapper $this$loadNativeLibrary_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)NativeLoader.initialize());
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                ((Throwable)it).printStackTrace();
            }
            NATIVE_LIBRARY_LOADED = true;
        }
    }

    @NotNull
    public final int[] decode(@NotNull WebPDecoderOptions options, @NotNull byte[] data, int offset, int length, @NotNull int[] out) {
        VP8StatusCode status;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (!(offset + length <= data.length)) {
            boolean $i$a$-require-WebPWrapper$decode$22 = false;
            String $i$a$-require-WebPWrapper$decode$22 = "Offset/length exceeds array size";
            throw new IllegalArgumentException($i$a$-require-WebPWrapper$decode$22.toString());
        }
        int[] pixels = WebP.decode(options.fPointer, data, offset, length, out, Intrinsics.areEqual((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.BIG_ENDIAN));
        VP8StatusCode vP8StatusCode = status = VP8StatusCode.Companion.getStatusCode(out[0]);
        switch (vP8StatusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[vP8StatusCode.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)pixels);
                return pixels;
            }
            case 2: {
                throw new OutOfMemoryError();
            }
        }
        throw new IOException("Decode returned code " + status);
    }

    @NotNull
    public final int[] getInfo(@NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] out = new int[2];
        int result = WebP.getInfo(data, offset, length, out);
        if (result == 0) {
            throw new IOException("Invalid WebP data");
        }
        return out;
    }

    @NotNull
    public final byte[] encodeRGBA(@NotNull WebPEncoderOptions options, @NotNull byte[] rgbaData, int width, int height, int stride) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)rgbaData, (String)"rgbaData");
        byte[] byArray = WebP.encodeRGBA(options.getPointer(), rgbaData, width, height, stride);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encodeRGBA(...)");
        return byArray;
    }

    @NotNull
    public final byte[] encodeRGB(@NotNull WebPEncoderOptions options, @NotNull byte[] rgbaData, int width, int height, int stride) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)rgbaData, (String)"rgbaData");
        byte[] byArray = WebP.encodeRGB(options.getPointer(), rgbaData, width, height, stride);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encodeRGB(...)");
        return byArray;
    }

    static {
        Cleaner cleaner = Cleaner.create();
        Intrinsics.checkNotNullExpressionValue((Object)cleaner, (String)"create(...)");
        WebPWrapper.cleaner = cleaner;
        WebPWrapper.loadNativeLibrary();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VP8StatusCode.values().length];
            try {
                nArray[VP8StatusCode.Ok.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VP8StatusCode.OutOfMemory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

