/*
 * Decompiled with CFR 0.152.
 */
package com.github.uzrnem.verify;

import java.util.regex.Pattern;

public class Check {
    public static Boolean isNull(Object value) {
        return value == null;
    }

    public static Boolean isEmpty(String value) {
        return value == null || value == "";
    }

    public static Boolean isUppercase(String value) {
        return Check.isEmpty(value) != false || value.toUpperCase() == value;
    }

    public static Boolean isLowercase(String value) {
        return Check.isEmpty(value) != false || value.toLowerCase() == value;
    }

    public static Boolean isLengthLessThan(String value, Integer limit) {
        return Check.isEmpty(value) != false || value.length() < limit;
    }

    public static Boolean isLessThan(Integer value, Integer limit) {
        return Check.isNull(value) != false || value < limit;
    }

    public static Boolean isLengthGreaterThan(String value, Integer limit) {
        return Check.isEmpty(value) != false || value.length() > limit;
    }

    public static Boolean isGreaterThan(Integer value, Integer limit) {
        return Check.isNull(value) != false || value > limit;
    }

    public static Boolean isEmail(String email) {
        if (Check.isEmpty(email).booleanValue()) {
            return true;
        }
        String emailRegex = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
        Pattern pat = Pattern.compile(emailRegex);
        return pat.matcher(email).matches();
    }

    public static Boolean isAlphabetic(String value) {
        if (Check.isEmpty(value).booleanValue()) {
            return true;
        }
        String regex = "^[a-zA-Z]*$";
        Pattern pat = Pattern.compile(regex);
        return pat.matcher(value).matches();
    }

    public static Boolean isAlphaNumeric(String value) {
        if (Check.isEmpty(value).booleanValue()) {
            return true;
        }
        String regex = "^(?=.*[a-zA-Z])(?=.*[0-9])[A-Za-z0-9]+$";
        Pattern pat = Pattern.compile(regex);
        return pat.matcher(value).matches();
    }

    public static Boolean isNumeric(String value) {
        if (Check.isEmpty(value).booleanValue()) {
            return true;
        }
        String regex = "[+-]?[0-9]+(\\\\.[0-9]+)?([Ee][+-]?[0-9]+)?";
        Pattern pat = Pattern.compile(regex);
        return pat.matcher(value).matches();
    }
}

