/*
 * Decompiled with CFR 0.152.
 */
package com.github.uzrnem.verify;

import com.github.uzrnem.verify.Check;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Validator<T> {
    public static final int ALPHABETIC = 1;
    public static final int ALPHANUMERIC = 2;
    public static final int NUMERIC = 4;
    public static final int UPPERCASE = 16;
    public static final int LOWERCASE = 32;
    public static final int REQUIRED = 64;
    public static final int EMAIL = 256;
    private static final int TYPE_NORMAL = 1;
    private static final int TYPE_MIN = 2;
    private static final int TYPE_MAX = 3;
    private static final int TYPE_CONTAINS = 4;
    private static final int TYPE_NOT_CONTAINS = 5;
    private static final int TYPE_CUSTOM = 6;
    private List<Rules> rulesList = null;
    private List<String> errors = null;
    private Consumer<Object> sop = Validator::println;

    private Validator<T> initList() {
        this.rulesList = new ArrayList<Rules>();
        this.errors = new ArrayList<String>();
        return this;
    }

    private List<Rules> getValidateRules() {
        return this.rulesList;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public static <T> Validator<T> stream(Class<T> classRef) {
        return super.initList();
    }

    private static void println(Object str) {
    }

    public <C> Validator<T> add(Function<T, C> getVal, Integer flags, String error) {
        this.getValidateRules().add(new Rules().withValFunc(getVal).withType(1).withFlags(flags).withErrorMsg(error));
        return this;
    }

    public <C> Validator<T> min(Function<T, C> getVal, int limit, String error) {
        this.getValidateRules().add(new Rules().withValFunc(getVal).withType(2).withLimit(limit).withErrorMsg(error));
        return this;
    }

    public <C> Validator<T> max(Function<T, C> getVal, int limit, String error) {
        this.getValidateRules().add(new Rules().withValFunc(getVal).withType(3).withLimit(limit).withErrorMsg(error));
        return this;
    }

    public <C> Validator<T> in(Function<T, C> getVal, List<C> asList, String error) {
        this.getValidateRules().add(new Rules().withValFunc(getVal).withType(4).withListIn(asList).withErrorMsg(error));
        return this;
    }

    public <C> Validator<T> notIn(Function<T, C> getVal, List<C> asList, String error) {
        this.getValidateRules().add(new Rules().withValFunc(getVal).withType(5).withListIn(asList).withErrorMsg(error));
        return this;
    }

    public <C> Validator<T> check(Function<T, C> getVal, Predicate<C> isTrue, String error) {
        this.getValidateRules().add(new Rules().withValFunc(getVal).withType(6).withCheckFunc(isTrue).withErrorMsg(error));
        return this;
    }

    protected Boolean checkFlag(Integer rules, Integer flag) {
        return (rules & flag) == flag;
    }

    public boolean test(T m) {
        this.getErrors().clear();
        this.getValidateRules().forEach(rules -> {
            Object value = rules.getValFunc().apply(m);
            this.sop.accept(value);
            switch (rules.getType()) {
                case 1: {
                    if (this.checkFlag(rules.getFlags(), 64).booleanValue()) {
                        if (value instanceof String) {
                            if (!Check.isEmpty((String)value).booleanValue()) break;
                            this.getErrors().add(rules.getErrorMsg());
                            break;
                        }
                        if (!Check.isNull(value).booleanValue()) break;
                        this.getErrors().add(rules.getErrorMsg());
                        break;
                    }
                    if (this.checkFlag(rules.getFlags(), 16).booleanValue() && !Check.isUppercase((String)value).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (this.checkFlag(rules.getFlags(), 32).booleanValue() && !Check.isLowercase((String)value).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (this.checkFlag(rules.getFlags(), 1).booleanValue() && !Check.isAlphabetic((String)value).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (this.checkFlag(rules.getFlags(), 2).booleanValue() && !Check.isAlphaNumeric((String)value).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (this.checkFlag(rules.getFlags(), 4).booleanValue() && !Check.isNumeric((String)value).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (!this.checkFlag(rules.getFlags(), 256).booleanValue() || Check.isEmail((String)value).booleanValue()) break;
                    this.getErrors().add(rules.getErrorMsg());
                    break;
                }
                case 2: {
                    if (value instanceof String && Check.isLengthLessThan((String)value, rules.getLimit()).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (!(value instanceof Integer) || !Check.isLessThan((Integer)value, rules.getLimit()).booleanValue()) break;
                    this.getErrors().add(rules.getErrorMsg());
                    break;
                }
                case 3: {
                    if (value instanceof String && Check.isLengthGreaterThan((String)value, rules.getLimit()).booleanValue()) {
                        this.getErrors().add(rules.getErrorMsg());
                    }
                    if (!(value instanceof Integer) || !Check.isGreaterThan((Integer)value, rules.getLimit()).booleanValue()) break;
                    this.getErrors().add(rules.getErrorMsg());
                    break;
                }
                case 4: {
                    if (rules.getListIn().contains(value)) break;
                    this.getErrors().add(rules.getErrorMsg());
                    break;
                }
                case 5: {
                    if (!rules.getListIn().contains(value)) break;
                    this.getErrors().add(rules.getErrorMsg());
                    break;
                }
                case 6: {
                    if (rules.getCheckFunc().test(value)) break;
                    this.getErrors().add(rules.getErrorMsg());
                    break;
                }
            }
        });
        return this.errors.size() == 0;
    }

    static class Rules {
        private Function valFunc;
        private Integer flags;
        private Integer type;
        private Integer limit;
        private List listIn;
        private String errorMsg;
        private Predicate checkFunc;

        Rules() {
        }

        public Function getValFunc() {
            return this.valFunc;
        }

        public Rules withValFunc(Function valFunc) {
            this.valFunc = valFunc;
            return this;
        }

        public Integer getFlags() {
            return this.flags;
        }

        public Rules withFlags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public Integer getType() {
            return this.type;
        }

        public Rules withType(Integer typeNormal) {
            this.type = typeNormal;
            return this;
        }

        public List getListIn() {
            return this.listIn;
        }

        public Rules withListIn(List listIn) {
            this.listIn = listIn;
            return this;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public Rules withLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Rules withErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public Predicate getCheckFunc() {
            return this.checkFunc;
        }

        public Rules withCheckFunc(Predicate checkFunc) {
            this.checkFunc = checkFunc;
            return this;
        }
    }
}

