/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm.util;

import com.browserup.bup.mitm.exception.KeyStoreAccessException;
import com.browserup.bup.mitm.exception.TrustSourceException;
import com.browserup.bup.mitm.exception.UncheckedIOException;
import com.browserup.bup.mitm.tools.DefaultSecurityProviderTool;
import com.browserup.bup.mitm.tools.SecurityProviderTool;
import com.browserup.bup.util.ClasspathResourceUtil;
import com.google.common.base.Suppliers;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustUtil {
    private static final Logger log = LoggerFactory.getLogger(TrustUtil.class);
    private static final Pattern CA_PEM_PATTERN = Pattern.compile("-----BEGIN CERTIFICATE-----.+?-----END CERTIFICATE-----", 32);
    private static final String DEFAULT_TRUSTED_CA_RESOURCE = "/cacerts.pem";
    public static final X509Certificate[] EMPTY_CERTIFICATE_ARRAY = new X509Certificate[0];
    private static final SecurityProviderTool securityProviderTool = new DefaultSecurityProviderTool();
    private static final Supplier<X509Certificate[]> javaTrustedCAs = Suppliers.memoize(() -> {
        X509TrustManager defaultTrustManager = TrustUtil.getDefaultJavaTrustManager();
        X509Certificate[] defaultJavaTrustedCerts = defaultTrustManager.getAcceptedIssuers();
        if (defaultJavaTrustedCerts != null) {
            return defaultJavaTrustedCerts;
        }
        return EMPTY_CERTIFICATE_ARRAY;
    });
    private static final Supplier<X509Certificate[]> builtinTrustedCAs = Suppliers.memoize(() -> {
        try {
            String allCAs = ClasspathResourceUtil.classpathResourceToString(DEFAULT_TRUSTED_CA_RESOURCE, StandardCharsets.UTF_8);
            return TrustUtil.readX509CertificatesFromPem(allCAs);
        }
        catch (UncheckedIOException e) {
            log.warn("Unable to load built-in trusted CAs; no built-in CAs will be trusted", (Throwable)e);
            return new X509Certificate[0];
        }
    });

    public static X509Certificate[] getBuiltinTrustedCAs() {
        return builtinTrustedCAs.get();
    }

    public static X509Certificate[] getJavaTrustedCAs() {
        return javaTrustedCAs.get();
    }

    public static X509Certificate[] readX509CertificatesFromPem(String pemEncodedCAs) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(500);
        Matcher pemMatcher = CA_PEM_PATTERN.matcher(pemEncodedCAs);
        while (pemMatcher.find()) {
            String singleCAPem = pemMatcher.group();
            X509Certificate certificate = TrustUtil.readSingleX509Certificate(singleCAPem);
            certificates.add(certificate);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static X509Certificate readSingleX509Certificate(String x509CertificateAsPem) {
        return securityProviderTool.decodePemEncodedCertificate(new StringReader(x509CertificateAsPem));
    }

    public static X509TrustManager getDefaultJavaTrustManager() {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new TrustSourceException("Unable to retrieve default TrustManagerFactory", e);
        }
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new TrustSourceException("No X509TrustManager found");
    }

    public static List<X509Certificate> extractTrustedCertificateEntries(KeyStore trustStore) {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            ArrayList<String> keyStoreAliases = Collections.list(aliases);
            ArrayList<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>(keyStoreAliases.size());
            for (String alias : keyStoreAliases) {
                if (!trustStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) continue;
                Certificate certificate = trustStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) {
                    log.debug("Skipping non-X509Certificate in KeyStore. Certificate type: {}", (Object)certificate.getType());
                    continue;
                }
                trustedCertificates.add((X509Certificate)certificate);
            }
            return trustedCertificates;
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Error occurred while retrieving trusted CAs from KeyStore", e);
        }
    }
}

