/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm;

import com.browserup.bup.mitm.CertificateAndKey;
import com.browserup.bup.mitm.CertificateAndKeySource;
import com.browserup.bup.mitm.KeyStoreCertificateSource;
import com.browserup.bup.mitm.exception.CertificateSourceException;
import com.browserup.bup.mitm.tools.DefaultSecurityProviderTool;
import com.browserup.bup.mitm.tools.SecurityProviderTool;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreFileCertificateSource
implements CertificateAndKeySource {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreFileCertificateSource.class);
    private final String keyStoreClasspathResource;
    private final File keyStoreFile;
    private final String keyStoreType;
    private final String keyStorePassword;
    private final String privateKeyAlias;
    private SecurityProviderTool securityProviderTool = new DefaultSecurityProviderTool();
    private final Supplier<CertificateAndKey> certificateAndKey = Suppliers.memoize(this::loadKeyStore);

    public KeyStoreFileCertificateSource(String keyStoreType, String keyStoreClasspathResource, String privateKeyAlias, String keyStorePassword) {
        if (keyStoreClasspathResource == null) {
            throw new IllegalArgumentException("The classpath location of the KeyStore cannot be null");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("KeyStore type cannot be null");
        }
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("Alias of the private key in the KeyStore cannot be null");
        }
        this.keyStoreClasspathResource = keyStoreClasspathResource;
        this.keyStoreFile = null;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.privateKeyAlias = privateKeyAlias;
    }

    public KeyStoreFileCertificateSource(String keyStoreType, File keyStoreFile, String privateKeyAlias, String keyStorePassword) {
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("The KeyStore file cannot be null");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("KeyStore type cannot be null");
        }
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("Alias of the private key in the KeyStore cannot be null");
        }
        this.keyStoreFile = keyStoreFile;
        this.keyStoreClasspathResource = null;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.privateKeyAlias = privateKeyAlias;
    }

    public KeyStoreFileCertificateSource certificateTool(SecurityProviderTool securityProviderTool) {
        this.securityProviderTool = securityProviderTool;
        return this;
    }

    @Override
    public CertificateAndKey load() {
        return this.certificateAndKey.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CertificateAndKey loadKeyStore() {
        KeyStore keyStore;
        block17: {
            if (this.keyStoreFile != null) {
                keyStore = this.securityProviderTool.loadKeyStore(this.keyStoreFile, this.keyStoreType, this.keyStorePassword);
            } else {
                Path tempKeyStoreFile = null;
                try {
                    try (InputStream keystoreAsStream = KeyStoreFileCertificateSource.class.getResourceAsStream(this.keyStoreClasspathResource);){
                        tempKeyStoreFile = Files.createTempFile("keystore", "temp", new FileAttribute[0]);
                        Files.copy(keystoreAsStream, tempKeyStoreFile, StandardCopyOption.REPLACE_EXISTING);
                        keyStore = this.securityProviderTool.loadKeyStore(tempKeyStoreFile.toFile(), this.keyStoreType, this.keyStorePassword);
                    }
                    if (tempKeyStoreFile == null) break block17;
                }
                catch (IOException e) {
                    try {
                        throw new CertificateSourceException("Unable to open KeyStore classpath resource: " + this.keyStoreClasspathResource, e);
                    }
                    catch (Throwable throwable) {
                        if (tempKeyStoreFile == null) throw throwable;
                        try {
                            Files.deleteIfExists(tempKeyStoreFile);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            log.warn("Unable to delete temporary KeyStore file: {}.", (Object)tempKeyStoreFile.toAbsolutePath());
                        }
                        throw throwable;
                    }
                }
                try {
                    Files.deleteIfExists(tempKeyStoreFile);
                }
                catch (IOException e) {
                    log.warn("Unable to delete temporary KeyStore file: {}.", (Object)tempKeyStoreFile.toAbsolutePath());
                }
            }
        }
        KeyStoreCertificateSource keyStoreCertificateSource = new KeyStoreCertificateSource(keyStore, this.privateKeyAlias, this.keyStorePassword);
        return keyStoreCertificateSource.load();
    }
}

