/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.jbehave.junit.monitoring;

import com.github.valfirst.jbehave.junit.monitoring.JUnitStringDecorator;
import com.github.valfirst.jbehave.junit.monitoring.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.PassingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.NullStoryReporter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnitScenarioReporter
extends NullStoryReporter {
    private Logger logger = new Logger();
    private RunNotifier notifier;
    private final Description rootDescription;
    private final int totalTests;
    private final Keywords keywords;
    private final boolean notifyFinished;
    private PendingStepStrategy pendingStepStrategy = new PassingUponPendingStep();
    private ThreadLocal<TestState> testState = new ThreadLocal<TestState>(){

        @Override
        protected TestState initialValue() {
            return new TestState();
        }
    };
    private AtomicInteger testCounter = new AtomicInteger();

    public JUnitScenarioReporter(RunNotifier notifier, int totalTests, Description rootDescription, Keywords keywords, boolean notifyFinished) {
        this.totalTests = totalTests;
        this.rootDescription = rootDescription;
        this.notifier = notifier;
        this.keywords = keywords;
        this.notifyFinished = notifyFinished;
    }

    public JUnitScenarioReporter(RunNotifier notifier, int totalTests, Description rootDescription, Keywords keywords) {
        this(notifier, totalTests, rootDescription, keywords, true);
    }

    public void beforeStory(Story story, boolean isGivenStory) {
        this.logger.info("Before Story: {} {}", story.getName(), isGivenStory ? "(given story)" : "");
        TestState testState = this.testState.get();
        if (isGivenStory) {
            if (testState.currentStep != null) {
                this.notifier.fireTestStarted(testState.currentStep);
            }
            testState.givenStoryContext = true;
        } else {
            if (this.testCounter.get() == 0) {
                this.notifier.fireTestRunStarted(this.rootDescription);
            }
            for (Description storyDescription : this.rootDescription.getChildren()) {
                if (storyDescription.isSuite() && storyDescription.getDisplayName().equals(JUnitStringDecorator.getJunitSafeString(story.getName()))) {
                    testState.currentStoryDescription = storyDescription;
                    this.notifier.fireTestStarted(storyDescription);
                    testState.scenarioDescriptions = storyDescription.getChildren().iterator();
                    testState.moveToNextScenario();
                    this.processBeforeStory();
                    testState.currentStep = testState.currentStoryDescription;
                    continue;
                }
                if (!storyDescription.isTest() || storyDescription.getMethodName() == null || !storyDescription.getMethodName().equals(story.getName())) continue;
                testState.currentStoryDescription = storyDescription;
                this.notifier.fireTestStarted(testState.currentStoryDescription);
                testState.currentStep = testState.currentStoryDescription;
            }
        }
    }

    public void afterStory(boolean isGivenStory) {
        TestState testState = this.testState.get();
        this.logger.info("After Story: {} {}", testState.currentStoryDescription.getDisplayName(), isGivenStory ? "(given story)" : "");
        if (isGivenStory) {
            testState.givenStoryContext = false;
            if (testState.currentStep != null) {
                this.notifier.fireTestFinished(testState.currentStep);
            }
            this.prepareNextStep();
            this.processBeforeScenario();
        } else {
            if (!testState.failedSteps.contains(testState.currentStoryDescription)) {
                this.notifier.fireTestFinished(testState.currentStoryDescription);
                if (testState.currentStoryDescription.isTest()) {
                    this.testCounter.incrementAndGet();
                }
            }
            this.processAfterStory();
            if (this.testCounter.get() == this.totalTests && this.notifyFinished) {
                Result result = new Result();
                this.notifier.fireTestRunFinished(result);
            }
        }
    }

    public void beforeScenario(String title) {
        this.logger.info("Before Scenario: {}", title);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            this.notifier.fireTestStarted(testState.currentScenario);
            ArrayList children = testState.currentScenario.getChildren();
            List<Description> examples = this.filterExamples(children);
            if (!examples.isEmpty()) {
                testState.exampleDescriptions = examples.iterator();
                testState.currentExample = null;
            }
            if (children.size() > examples.size()) {
                ArrayList<Description> steps = new ArrayList<Description>(testState.currentScenario.getChildren());
                steps.removeAll(examples);
                testState.stepDescriptions = this.getAllDescendants(steps).iterator();
                testState.moveToNextStep();
                this.processBeforeScenario();
            }
        }
    }

    private List<Description> filterExamples(List<Description> children) {
        for (int i = 0; i < children.size(); ++i) {
            Description child = children.get(i);
            boolean isExample = child.getDisplayName().startsWith(this.keywords.examplesTableRow() + " ");
            if (!isExample) continue;
            return children.subList(i, children.size());
        }
        return Collections.emptyList();
    }

    private Collection<Description> getAllDescendants(List<Description> steps) {
        ArrayList<Description> descendants = new ArrayList<Description>();
        for (Description child : steps) {
            descendants.add(child);
            descendants.addAll(this.getAllDescendants(child.getChildren()));
        }
        return descendants;
    }

    public void afterScenario() {
        TestState testState = this.testState.get();
        this.logger.info("After Scenario: {}", testState.currentScenario.getDisplayName());
        if (!testState.givenStoryContext) {
            this.notifier.fireTestFinished(testState.currentScenario);
            this.processAfterScenario();
            testState.moveToNextScenario();
        }
    }

    private void processBeforeStory() {
        TestState testState = this.testState.get();
        Description currentScenario = testState.currentScenario;
        if (currentScenario != null && currentScenario.getDisplayName().startsWith("@BeforeStory")) {
            this.notifier.fireTestStarted(currentScenario);
            this.notifier.fireTestFinished(currentScenario);
            testState.moveToNextScenario();
        }
    }

    private void processAfterStory() {
        TestState testState = this.testState.get();
        Description currentScenario = testState.currentScenario;
        if (currentScenario != null) {
            if (currentScenario.getDisplayName().startsWith("@AfterStory")) {
                this.notifier.fireTestStarted(currentScenario);
                this.notifier.fireTestFinished(currentScenario);
                testState.moveToNextScenario();
            } else {
                testState.moveToNextScenario();
                this.processAfterStory();
            }
        }
    }

    private void processBeforeScenario() {
        Description currentStep = this.testState.get().currentStep;
        if (currentStep != null && currentStep.getDisplayName().startsWith("@BeforeScenario")) {
            this.notifier.fireTestStarted(currentStep);
            this.notifier.fireTestFinished(currentStep);
            this.prepareNextStep();
        }
    }

    private void processAfterScenario() {
        TestState testState = this.testState.get();
        Description currentStep = testState.currentStep;
        if (currentStep != null) {
            if (currentStep.getDisplayName().startsWith("@AfterScenario")) {
                this.notifier.fireTestStarted(currentStep);
                this.notifier.fireTestFinished(currentStep);
                this.prepareNextStep();
            } else {
                testState.moveToNextStep();
                this.processAfterScenario();
            }
        }
    }

    public void example(Map<String, String> arg0) {
        this.logger.info("Example: {}", arg0);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            if (testState.currentExample != null && testState.stepDescriptions != null) {
                this.processAfterScenario();
            }
            testState.moveToNextExample();
            testState.stepDescriptions = testState.currentExample.getChildren().iterator();
            testState.moveToNextStep();
            this.processBeforeScenario();
        }
    }

    public void beforeStep(String title) {
        this.logger.info("Before Step: {}", title);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            this.notifier.fireTestStarted(testState.currentStep);
        }
    }

    public void failed(String step, Throwable e) {
        Throwable thrownException = e instanceof UUIDExceptionWrapper ? e.getCause() : e;
        this.logger.info("Step Failed: {} (cause: {})", step, thrownException.getMessage());
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            if (thrownException instanceof BeforeOrAfterFailed) {
                this.notifier.fireTestStarted(testState.currentStep);
            }
            this.notifier.fireTestFailure(new Failure(testState.currentStep, thrownException));
            this.notifier.fireTestFinished(testState.currentStep);
            testState.failedSteps.add(testState.currentStep);
            this.prepareNextStep();
        }
    }

    public void successful(String step) {
        this.logger.info("Step Succesful: {}", step);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            this.notifier.fireTestFinished(testState.currentStep);
            this.prepareNextStep();
        }
    }

    private void prepareNextStep() {
        TestState testState = this.testState.get();
        if (testState.currentStep != null && testState.currentStep.isTest()) {
            this.testCounter.incrementAndGet();
        }
        if (testState.stepDescriptions != null) {
            testState.moveToNextStep();
        }
    }

    public void pending(String arg0) {
        this.logger.info("Pending: {}", arg0);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            if (this.pendingStepStrategy instanceof FailingUponPendingStep) {
                this.notifier.fireTestStarted(testState.currentStep);
                this.notifier.fireTestFailure(new Failure(testState.currentStep, (Throwable)new RuntimeException("Step is pending!")));
                testState.failedSteps.add(testState.currentStep);
                this.notifier.fireTestFinished(testState.currentStep);
            } else {
                this.notifier.fireTestIgnored(testState.currentStep);
            }
            this.prepareNextStep();
        }
    }

    public void ignorable(String arg0) {
        this.logger.info("Ignorable: {}", arg0);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            this.notifier.fireTestIgnored(testState.currentStep);
            this.prepareNextStep();
        }
    }

    public void notPerformed(String arg0) {
        this.logger.info("Not performed: {}", arg0);
        TestState testState = this.testState.get();
        if (!testState.givenStoryContext) {
            this.notifier.fireTestIgnored(testState.currentStep);
            this.prepareNextStep();
        }
    }

    public void scenarioNotAllowed(Scenario scenario, String filter) {
        this.logger.info("Scenario not allowed: {} {}", scenario, filter);
        TestState testState = this.testState.get();
        this.notifier.fireTestIgnored(testState.currentStep);
        this.notifier.fireTestIgnored(testState.currentScenario);
    }

    public void usePendingStepStrategy(PendingStepStrategy pendingStepStrategy) {
        this.pendingStepStrategy = pendingStepStrategy;
    }

    private class TestState {
        private Description currentStep;
        private Iterator<Description> stepDescriptions;
        private Description currentScenario;
        private Iterator<Description> scenarioDescriptions;
        private Description currentExample;
        private Iterator<Description> exampleDescriptions;
        private Description currentStoryDescription;
        private boolean givenStoryContext;
        private Set<Description> failedSteps = new HashSet<Description>();

        private TestState() {
        }

        private void moveToNextScenario() {
            this.currentStep = this.currentScenario = this.getNextOrNull(this.scenarioDescriptions);
        }

        private void moveToNextExample() {
            this.currentExample = this.getNextOrNull(this.exampleDescriptions);
        }

        private void moveToNextStep() {
            this.currentStep = this.getNextOrNull(this.stepDescriptions);
        }

        private <T> T getNextOrNull(Iterator<T> iterator) {
            return iterator.hasNext() ? (T)iterator.next() : null;
        }
    }
}

