/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.jbehave.junit.monitoring;

import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public class Logger {
    public static final String PROP_JJM_LOGLEVEL = "jjm.loglevel";
    private volatile LogLevel logLevel;
    private PrintStream logStream = System.out;

    public void info(String message, Object ... params) {
        this.printMessage(LogLevel.INFO, message, params);
    }

    public void debug(String message, Object ... params) {
        this.printMessage(LogLevel.DEBUG, message, params);
    }

    private boolean isLevelEnabled(LogLevel level) {
        return this.getLogLevel().ordinal() >= level.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogLevel getLogLevel() {
        if (this.logLevel != null) {
            return this.logLevel;
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (this.logLevel == null) {
                String configuredLevel = System.getProperty(PROP_JJM_LOGLEVEL);
                if (StringUtils.isBlank((CharSequence)configuredLevel)) {
                    this.logLevel = LogLevel.NONE;
                } else {
                    configuredLevel = configuredLevel.trim();
                    try {
                        this.logLevel = LogLevel.valueOf(configuredLevel.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.logLevel = LogLevel.NONE;
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.logLevel;
        }
    }

    private void printMessage(LogLevel level, String message, Object ... params) {
        if (this.isLevelEnabled(level)) {
            String format = message.replace("{}", "%s");
            Object[] strings = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                strings[i] = String.valueOf(params[i]);
            }
            this.logStream.println((Object)((Object)level) + ": " + String.format(format, strings));
        }
    }

    static enum LogLevel {
        NONE,
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

