/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.jbehave.junit.monitoring;

import com.github.valfirst.jbehave.junit.monitoring.JUnitDescriptionGenerator;
import com.github.valfirst.jbehave.junit.monitoring.JUnitScenarioReporter;
import com.github.valfirst.jbehave.junit.monitoring.StoryPathsExtractor;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitReportingRunner
extends BlockJUnit4ClassRunner {
    private Embedder configuredEmbedder;
    private Configuration configuration;
    private int numberOfTestCases;
    private Description rootDescription;
    private ConfigurableEmbedder configurableEmbedder;

    public JUnitReportingRunner(Class<? extends ConfigurableEmbedder> testClass) throws InitializationError, ReflectiveOperationException {
        super(testClass);
        this.configurableEmbedder = testClass.newInstance();
        this.configuredEmbedder = this.configurableEmbedder.configuredEmbedder();
        this.configuration = this.configuredEmbedder.configuration();
        List<String> storyPaths = new StoryPathsExtractor(this.configurableEmbedder).getStoryPaths();
        StepMonitor originalStepMonitor = this.configuration.stepMonitor();
        this.configuration.useStepMonitor((StepMonitor)new NullStepMonitor());
        List<Description> storyDescriptions = this.buildDescriptionFromStories(storyPaths);
        this.configuration.useStepMonitor(originalStepMonitor);
        this.rootDescription = Description.createSuiteDescription(testClass);
        for (Description storyDescription : storyDescriptions) {
            this.rootDescription.addChild(storyDescription);
        }
    }

    public Description getDescription() {
        return this.rootDescription;
    }

    public int testCount() {
        return this.numberOfTestCases;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                JUnitScenarioReporter junitReporter = new JUnitScenarioReporter(notifier, JUnitReportingRunner.this.numberOfTestCases, JUnitReportingRunner.this.rootDescription, JUnitReportingRunner.this.configuration.keywords());
                junitReporter.usePendingStepStrategy(JUnitReportingRunner.this.configuration.pendingStepStrategy());
                JUnitReportingRunner.this.addToStoryReporterFormats(junitReporter);
                try {
                    JUnitReportingRunner.this.configurableEmbedder.run();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static EmbedderControls recommendedControls(Embedder embedder) {
        return embedder.embedderControls().doIgnoreFailureInView(true).doIgnoreFailureInStories(true).useThreads(1);
    }

    private List<CandidateSteps> getCandidateSteps() {
        List candidateSteps;
        InjectableStepsFactory stepsFactory = this.configurableEmbedder.stepsFactory();
        if (stepsFactory != null) {
            candidateSteps = stepsFactory.createCandidateSteps();
        } else {
            candidateSteps = this.configuredEmbedder.candidateSteps();
            if (candidateSteps == null || candidateSteps.isEmpty()) {
                candidateSteps = this.configuredEmbedder.stepsFactory().createCandidateSteps();
            }
        }
        return candidateSteps;
    }

    private void addToStoryReporterFormats(JUnitScenarioReporter junitReporter) {
        StoryReporterBuilder storyReporterBuilder = this.configuration.storyReporterBuilder();
        StoryReporterBuilder.ProvidedFormat junitReportFormat = new StoryReporterBuilder.ProvidedFormat((StoryReporter)junitReporter);
        storyReporterBuilder.withFormats(new Format[]{junitReportFormat});
    }

    private List<Description> buildDescriptionFromStories(List<String> storyPaths) {
        List<CandidateSteps> candidateSteps = this.getCandidateSteps();
        JUnitDescriptionGenerator descriptionGenerator = new JUnitDescriptionGenerator(candidateSteps, this.configuration);
        ArrayList<Description> storyDescriptions = new ArrayList<Description>();
        this.addSuite(storyDescriptions, "BeforeStories");
        PerformableTree performableTree = this.createPerformableTree(candidateSteps, storyPaths);
        storyDescriptions.addAll(descriptionGenerator.createDescriptionFrom(performableTree));
        this.addSuite(storyDescriptions, "AfterStories");
        this.numberOfTestCases += descriptionGenerator.getTestCases();
        return storyDescriptions;
    }

    private PerformableTree createPerformableTree(List<CandidateSteps> candidateSteps, List<String> storyPaths) {
        BatchFailures failures = new BatchFailures(this.configuredEmbedder.embedderControls().verboseFailures());
        PerformableTree performableTree = new PerformableTree();
        PerformableTree.RunContext context = performableTree.newRunContext(this.configuration, candidateSteps, this.configuredEmbedder.embedderMonitor(), this.configuredEmbedder.metaFilter(), failures);
        performableTree.addStories(context, this.storiesOf(performableTree, storyPaths));
        return performableTree;
    }

    private List<Story> storiesOf(PerformableTree performableTree, List<String> storyPaths) {
        ArrayList<Story> stories = new ArrayList<Story>();
        for (String storyPath : storyPaths) {
            stories.add(performableTree.storyOfPath(this.configuration, storyPath));
        }
        return stories;
    }

    private void addSuite(List<Description> storyDescriptions, String name) {
        storyDescriptions.add(Description.createTestDescription(Object.class, (String)name));
        ++this.numberOfTestCases;
    }
}

