/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class OverridableProperties {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final String propertySourceName;
    private final Properties properties;

    OverridableProperties(String propertySourceName) throws IOException {
        this.propertySourceName = propertySourceName;
        this.properties = this.getProperties();
    }

    private Properties getProperties() throws IOException {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.propertySourceName + ".properties");
        if (resourceAsStream != null) {
            return OverridableProperties.loadProperties(resourceAsStream);
        }
        return EMPTY_PROPERTIES;
    }

    private static Properties loadProperties(InputStream propertyResource) throws IOException {
        try (InputStream closablePropertyResource = propertyResource;){
            Properties loadedProperties = new Properties();
            loadedProperties.load(closablePropertyResource);
            Properties properties = loadedProperties;
            return properties;
        }
    }

    String getProperty(String propertyKey, String defaultValue) {
        String propertyFileProperty = this.properties.getProperty(propertyKey, defaultValue);
        return System.getProperty(this.propertySourceName + "." + propertyKey, propertyFileProperty);
    }
}

