/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.OverridableProperties;
import com.github.valfirst.slf4jtest.TestLogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.slf4j.ILoggerFactory;
import uk.org.lidalia.lang.ThreadLocal;
import uk.org.lidalia.slf4jext.Level;

public final class TestLoggerFactory
implements ILoggerFactory {
    private static final Supplier<TestLoggerFactory> INSTANCE = Suppliers.memoize(() -> {
        try {
            OverridableProperties properties = new OverridableProperties("slf4jtest");
            Level printLevel = TestLoggerFactory.getLevelProperty(properties, "print.level", "OFF");
            Level captureLevel = TestLoggerFactory.getLevelProperty(properties, "capture.level", "TRACE");
            return new TestLoggerFactory(printLevel, captureLevel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    });
    private final ConcurrentMap<String, TestLogger> loggers = new ConcurrentHashMap<String, TestLogger>();
    private final List<LoggingEvent> allLoggingEvents = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<List<LoggingEvent>> loggingEvents = new ThreadLocal<List>(ArrayList::new);
    private volatile Level printLevel;
    private volatile Level captureLevel;

    private static Level getLevelProperty(OverridableProperties properties, String propertyKey, String defaultValue) throws IOException {
        try {
            String printLevelProperty = properties.getProperty(propertyKey, defaultValue);
            return Level.valueOf((String)printLevelProperty);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid level name in property " + propertyKey + " of file slf4jtest.properties or System property slf4jtest." + propertyKey, e);
        }
    }

    public static TestLoggerFactory getInstance() {
        return INSTANCE.get();
    }

    public static TestLogger getTestLogger(Class<?> aClass) {
        return TestLoggerFactory.getInstance().getLogger(aClass);
    }

    public static TestLogger getTestLogger(String name) {
        return TestLoggerFactory.getInstance().getLogger(name);
    }

    public static Map<String, TestLogger> getAllTestLoggers() {
        return TestLoggerFactory.getInstance().getAllLoggers();
    }

    public static void clear() {
        TestLoggerFactory.getInstance().clearLoggers();
    }

    public static void clearAll() {
        TestLoggerFactory.getInstance().clearAllLoggers();
    }

    static void reset() {
        TestLoggerFactory.getInstance().doReset();
    }

    public static List<LoggingEvent> getLoggingEvents() {
        return TestLoggerFactory.getInstance().getLoggingEventsFromLoggers();
    }

    public static List<LoggingEvent> getAllLoggingEvents() {
        return TestLoggerFactory.getInstance().getAllLoggingEventsFromLoggers();
    }

    public TestLoggerFactory() {
        this(Level.OFF, Level.TRACE);
    }

    public TestLoggerFactory(Level printLevel) {
        this(printLevel, Level.TRACE);
    }

    public TestLoggerFactory(Level printLevel, Level captureLevel) {
        this.printLevel = (Level)Preconditions.checkNotNull((Object)printLevel);
        this.captureLevel = (Level)Preconditions.checkNotNull((Object)captureLevel);
    }

    public Level getPrintLevel() {
        return this.printLevel;
    }

    public Level getCaptureLevel() {
        return this.captureLevel;
    }

    public ImmutableMap<String, TestLogger> getAllLoggers() {
        return ImmutableMap.copyOf(this.loggers);
    }

    public TestLogger getLogger(Class<?> aClass) {
        return this.getLogger(aClass.getName());
    }

    public TestLogger getLogger(String name) {
        TestLogger newLogger = new TestLogger(name, this);
        return Optional.ofNullable(this.loggers.putIfAbsent(name, newLogger)).orElse(newLogger);
    }

    public void clearLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clear();
        }
        this.loggingEvents.get().clear();
    }

    public void clearAllLoggers() {
        for (TestLogger testLogger : this.loggers.values()) {
            testLogger.clearAll();
        }
        this.loggingEvents.reset();
        this.allLoggingEvents.clear();
    }

    void doReset() {
        this.clearAllLoggers();
        this.loggers.clear();
    }

    public ImmutableList<LoggingEvent> getLoggingEventsFromLoggers() {
        return ImmutableList.copyOf((Collection)this.loggingEvents.get());
    }

    public List<LoggingEvent> getAllLoggingEventsFromLoggers() {
        return this.allLoggingEvents;
    }

    void addLoggingEvent(LoggingEvent event) {
        this.loggingEvents.get().add(event);
        this.allLoggingEvents.add(event);
    }

    public void setPrintLevel(Level printLevel) {
        this.printLevel = (Level)Preconditions.checkNotNull((Object)printLevel);
    }

    public void setCaptureLevel(Level captureLevel) {
        this.captureLevel = (Level)Preconditions.checkNotNull((Object)captureLevel);
    }
}

