/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.AbstractTestLoggerAssert;
import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import uk.org.lidalia.slf4jext.Level;

public class LevelAssert
extends AbstractTestLoggerAssert<LevelAssert> {
    private final Level level;

    private static Predicate<LoggingEvent> messageWithSubstring(String substring) {
        return event -> event.getMessage().contains(substring);
    }

    private static Predicate<LoggingEvent> messageForPattern(String regex) {
        return event -> event.getMessage().matches(regex);
    }

    public LevelAssert(TestLogger logger, Level level) {
        super(logger, LevelAssert.class);
        this.level = level;
    }

    public LevelAssert hasNumberOfLogs(int expected) {
        long count = this.getLogCount(this.level, ignored -> true);
        if (count != (long)expected) {
            this.failWithMessage("Expected level %s to have %d log messages available, but %d were found", new Object[]{this.level, expected, count});
        }
        return this;
    }

    public LevelAssert hasMessageContaining(String substring) {
        long count = this.getLogCount(this.level, LevelAssert.messageWithSubstring(substring));
        if (count == 0L) {
            this.failWithMessage("Expected level %s to contain a log message containing `%s`, but it did not.\n\nLog messages found:%n%s", new Object[]{this.level, substring, this.eventsToLogMessage(this.level)});
        }
        return this;
    }

    public LevelAssert hasMessageMatching(String regex) {
        long count = this.getLogCount(this.level, LevelAssert.messageForPattern(regex));
        if (count == 0L) {
            this.failWithMessage("Expected level %s to contain a log message matching regex `%s`, but it did not.\n\nLog messages found:%n%s", new Object[]{this.level, regex, this.eventsToLogMessage()});
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LevelAssert that = (LevelAssert)((Object)o);
        return this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level);
    }

    private String eventsToLogMessage() {
        return ((List)this.loggingEventsSupplier.get()).stream().map(e -> "- " + e).collect(Collectors.joining("\n"));
    }

    private String eventsToLogMessage(Level level) {
        return ((List)this.loggingEventsSupplier.get()).stream().filter(event -> level.equals((Object)event.getLevel())).map(e -> "- " + e).collect(Collectors.joining("\n"));
    }
}

