/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.TestLogger;
import java.io.PrintStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public class LoggingEvent {
    private static final DateTimeFormatter ISO_FORMAT = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
    private static final Object[] emptyObjectArray = new Object[0];
    private final Level level;
    private final SortedMap<String, String> mdc;
    private final List<Marker> markers;
    private final List<KeyValuePair> keyValuePairs;
    private final Optional<Throwable> throwable;
    private final String message;
    private final List<Object> arguments;
    private final Optional<TestLogger> creatingLogger;
    private final Instant timestamp = Instant.now();
    private final String threadName = Thread.currentThread().getName();
    private final ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();

    public static LoggingEvent trace(String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, message, arguments);
    }

    public static LoggingEvent trace(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, throwable, message, arguments);
    }

    public static LoggingEvent trace(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, marker, message, arguments);
    }

    public static LoggingEvent trace(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, marker, throwable, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, throwable, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, marker, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent debug(String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, message, arguments);
    }

    public static LoggingEvent debug(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, throwable, message, arguments);
    }

    public static LoggingEvent debug(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, marker, message, arguments);
    }

    public static LoggingEvent debug(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, marker, throwable, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, throwable, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, marker, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent info(String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, message, arguments);
    }

    public static LoggingEvent info(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, throwable, message, arguments);
    }

    public static LoggingEvent info(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, marker, message, arguments);
    }

    public static LoggingEvent info(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, marker, throwable, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, throwable, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, marker, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent warn(String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, message, arguments);
    }

    public static LoggingEvent warn(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, throwable, message, arguments);
    }

    public static LoggingEvent warn(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, marker, message, arguments);
    }

    public static LoggingEvent warn(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, marker, throwable, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, throwable, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, marker, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent error(String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, message, arguments);
    }

    public static LoggingEvent error(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, throwable, message, arguments);
    }

    public static LoggingEvent error(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, marker, message, arguments);
    }

    public static LoggingEvent error(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, marker, throwable, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, throwable, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, marker, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent fromSlf4jEvent(org.slf4j.event.LoggingEvent event) {
        return LoggingEvent.fromSlf4jEvent(event, Collections.emptyMap());
    }

    public static LoggingEvent fromSlf4jEvent(org.slf4j.event.LoggingEvent event, Map<String, String> mdc) {
        List markers = event.getMarkers();
        List keyValuePairs = event.getKeyValuePairs();
        Object[] arguments = event.getArgumentArray();
        return new LoggingEvent(Optional.empty(), event.getLevel(), mdc, markers == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(markers)), keyValuePairs == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(keyValuePairs)), Optional.ofNullable(event.getThrowable()), event.getMessage(), arguments == null ? emptyObjectArray : arguments);
    }

    public LoggingEvent(Level level, String message, Object ... arguments) {
        this(level, Collections.emptySortedMap(), Optional.empty(), Optional.empty(), message, arguments);
    }

    public LoggingEvent(Level level, Throwable throwable, String message, Object ... arguments) {
        this(level, Collections.emptySortedMap(), Optional.empty(), Optional.ofNullable(throwable), message, arguments);
    }

    public LoggingEvent(Level level, Marker marker, String message, Object ... arguments) {
        this(level, Collections.emptySortedMap(), Optional.ofNullable(marker), Optional.empty(), message, arguments);
    }

    public LoggingEvent(Level level, Marker marker, Throwable throwable, String message, Object ... arguments) {
        this(level, Collections.emptySortedMap(), Optional.ofNullable(marker), Optional.ofNullable(throwable), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, String message, Object ... arguments) {
        this(level, mdc, Optional.empty(), Optional.empty(), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        this(level, mdc, Optional.empty(), Optional.ofNullable(throwable), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        this(level, mdc, Optional.ofNullable(marker), Optional.empty(), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        this(level, mdc, Optional.ofNullable(marker), Optional.ofNullable(throwable), message, arguments);
    }

    private LoggingEvent(Level level, Map<String, String> mdc, Optional<Marker> marker, Optional<Throwable> throwable, String message, Object ... arguments) {
        this(Optional.empty(), level, mdc, marker.map(Collections::singletonList).orElseGet(Collections::emptyList), Collections.emptyList(), throwable, message, arguments);
    }

    LoggingEvent(Optional<TestLogger> creatingLogger, Level level, Map<String, String> mdc, List<Marker> markers, List<KeyValuePair> keyValuePairs, Optional<Throwable> throwable, String message, Object ... arguments) {
        this.creatingLogger = creatingLogger;
        this.level = Objects.requireNonNull(level);
        this.mdc = Objects.requireNonNull(mdc).isEmpty() ? Collections.emptySortedMap() : Collections.unmodifiableSortedMap(new TreeMap<String, String>(mdc));
        this.markers = markers;
        this.keyValuePairs = keyValuePairs;
        this.throwable = Objects.requireNonNull(throwable);
        this.message = message;
        this.arguments = arguments.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(arguments)));
    }

    public Level getLevel() {
        return this.level;
    }

    public SortedMap<String, String> getMdc() {
        return this.mdc;
    }

    @Deprecated
    public Optional<Marker> getMarker() {
        if (this.markers.isEmpty()) {
            return Optional.empty();
        }
        if (this.markers.size() == 1) {
            return Optional.of(this.markers.get(0));
        }
        throw new IllegalStateException("LoggingEvent has more than one marker");
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public List<KeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public Optional<Throwable> getThrowable() {
        return this.throwable;
    }

    public TestLogger getCreatingLogger() {
        return this.creatingLogger.get();
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public ClassLoader getThreadContextClassLoader() {
        return this.threadContextClassLoader;
    }

    void print() {
        PrintStream output = this.printStreamForLevel();
        output.println(this.formatLogStatement());
        this.throwable.ifPresent(throwableToPrint -> throwableToPrint.printStackTrace(output));
    }

    private String formatLogStatement() {
        return ISO_FORMAT.format(this.getTimestamp()) + " [" + this.getThreadName() + "] " + this.getLevel() + this.safeLoggerName() + " - " + this.getFormattedMessage();
    }

    private String safeLoggerName() {
        return this.creatingLogger.map(logger -> " " + logger.getName()).orElse("");
    }

    public String getFormattedMessage() {
        Object[] argumentsWithNulls = this.getArguments().toArray();
        return MessageFormatter.arrayFormat((String)this.getMessage(), (Object[])argumentsWithNulls).getMessage();
    }

    private PrintStream printStreamForLevel() {
        switch (this.level) {
            case ERROR: 
            case WARN: {
                return System.err;
            }
        }
        return System.out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingEvent that = (LoggingEvent)o;
        return this.level == that.level && Objects.equals(this.mdc, that.mdc) && Objects.equals(this.markers, that.markers) && Objects.equals(this.keyValuePairs, that.keyValuePairs) && Objects.equals(this.throwable, that.throwable) && Objects.equals(this.message, that.message) && Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.mdc, this.markers, this.keyValuePairs, this.throwable, this.message, this.arguments);
    }

    public String toString() {
        return "LoggingEvent{level=" + this.level + ", mdc=" + this.mdc + ", markers=" + this.markers + ", keyValuePairs=" + this.keyValuePairs + ", throwable=" + this.throwable + ", message=" + (this.message == null ? "null" : '\'' + this.message + '\'') + ", arguments=" + this.arguments + '}';
    }
}

