/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.CheckReturnValue;
import org.slf4j.spi.DefaultLoggingEventBuilder;

public class TestLoggingEventBuilder
extends DefaultLoggingEventBuilder {
    public TestLoggingEventBuilder(Logger logger, Level level) {
        super(logger, level);
        this.loggingEvent = new TestLoggingEvent(level, logger);
    }

    public LoggingEvent toLoggingEvent() {
        return this.loggingEvent;
    }

    @CheckReturnValue
    public TestLoggingEventBuilder setCause(Throwable cause) {
        return (TestLoggingEventBuilder)super.setCause(cause);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder addMarker(Marker marker) {
        return (TestLoggingEventBuilder)super.addMarker(marker);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder addArgument(Object p) {
        return (TestLoggingEventBuilder)super.addArgument(p);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        return (TestLoggingEventBuilder)super.addArgument(objectSupplier);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder addKeyValue(String key, Object value) {
        return (TestLoggingEventBuilder)super.addKeyValue(key, value);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder addKeyValue(String key, Supplier<Object> valueSupplier) {
        return (TestLoggingEventBuilder)super.addKeyValue(key, valueSupplier);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder setMessage(String message) {
        return (TestLoggingEventBuilder)super.setMessage(message);
    }

    @CheckReturnValue
    public TestLoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        return (TestLoggingEventBuilder)super.setMessage(messageSupplier);
    }

    static class TestLoggingEvent
    extends DefaultLoggingEvent {
        private List<KeyValuePair> keyValuePairs = null;

        public TestLoggingEvent(Level level, Logger logger) {
            super(level, logger);
        }

        public void addKeyValue(String key, Object value) {
            if (this.keyValuePairs == null) {
                this.keyValuePairs = new ArrayList<KeyValuePair>();
            }
            this.keyValuePairs.add(new TestKeyValuePair(key, value));
        }

        public List<KeyValuePair> getKeyValuePairs() {
            return this.keyValuePairs;
        }
    }

    public static class TestKeyValuePair
    extends KeyValuePair {
        public TestKeyValuePair(String key, Object value) {
            super(key, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyValuePair)) {
                return false;
            }
            KeyValuePair that = (KeyValuePair)o;
            return Arrays.deepEquals(new Object[]{this.key, this.value}, new Object[]{that.key, that.value});
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.key, this.value});
        }
    }
}

