/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.OverridableProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.MDC;
import org.slf4j.helpers.BasicMDCAdapter;

public class TestMDCAdapter
extends BasicMDCAdapter {
    private final ThreadLocal<Map<String, String>> value;
    private final boolean initialEnable;
    private final boolean initialInherit;
    private final boolean initialReturnNullCopyWhenMdcNotSet;
    private final boolean initialAllowNullValues;
    private volatile boolean enable;
    private volatile boolean inherit;
    private volatile boolean returnNullCopyWhenMdcNotSet;
    private volatile boolean allowNullValues;

    public TestMDCAdapter() {
        this(OverridableProperties.createUnchecked("slf4jtest"));
    }

    TestMDCAdapter(OverridableProperties properties) {
        this.enable = this.initialEnable = TestMDCAdapter.getBooleanProperty(properties, "mdc.enable", true);
        this.inherit = this.initialInherit = TestMDCAdapter.getBooleanProperty(properties, "mdc.inherit", false);
        this.returnNullCopyWhenMdcNotSet = this.initialReturnNullCopyWhenMdcNotSet = TestMDCAdapter.getBooleanProperty(properties, "mdc.return.null.copy.when.mdc.not.set", false);
        this.allowNullValues = this.initialAllowNullValues = TestMDCAdapter.getBooleanProperty(properties, "mdc.allow.null.values", true);
        this.value = new InheritableThreadLocal<Map<String, String>>(){

            @Override
            protected Map<String, String> childValue(Map<String, String> parentValue) {
                if (TestMDCAdapter.this.enable && TestMDCAdapter.this.inherit && parentValue != null) {
                    return new HashMap<String, String>(parentValue);
                }
                return null;
            }
        };
    }

    static boolean getBooleanProperty(OverridableProperties properties, String propertyKey, boolean defaultValue) {
        return Boolean.parseBoolean(properties.getProperty(propertyKey, String.valueOf(defaultValue)));
    }

    public void put(String key, String val) {
        if (!this.enable) {
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (val == null && !this.allowNullValues) {
            throw new IllegalArgumentException("val cannot be null");
        }
        Map<String, String> map = this.value.get();
        if (map == null) {
            map = new HashMap<String, String>();
            this.value.set(map);
        }
        map.put(key, val);
    }

    public String get(String key) {
        if (!this.enable) {
            return null;
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> map = this.value.get();
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public void remove(String key) {
        if (!this.enable) {
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> map = this.value.get();
        if (map != null) {
            map.remove(key);
        }
    }

    public void clear() {
        if (!this.enable) {
            return;
        }
        Map<String, String> map = this.value.get();
        if (map == null) {
            return;
        }
        map.clear();
        this.value.remove();
    }

    public Map<String, String> getCopyOfContextMap() {
        if (!this.enable) {
            return null;
        }
        Map<String, String> map = this.value.get();
        if (map == null) {
            if (this.returnNullCopyWhenMdcNotSet) {
                return null;
            }
            return new TreeMap<String, String>();
        }
        return new TreeMap<String, String>(map);
    }

    Map<String, String> getContextMap() {
        Map<String, String> map = this.value.get();
        return map == null ? Collections.emptySortedMap() : map;
    }

    public void setContextMap(Map<String, String> contextMap) {
        if (!this.enable) {
            return;
        }
        this.clear();
        if (contextMap == null) {
            return;
        }
        if (contextMap.keySet().stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (!this.allowNullValues && contextMap.containsValue(null)) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this.value.set(new HashMap<String, String>(contextMap));
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public void setReturnNullCopyWhenMdcNotSet(boolean returnNullCopyWhenMdcNotSet) {
        this.returnNullCopyWhenMdcNotSet = returnNullCopyWhenMdcNotSet;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public boolean getInherit() {
        return this.inherit;
    }

    public boolean getAllowNullValues() {
        return this.allowNullValues;
    }

    public boolean getReturnNullCopyWhenMdcNotSet() {
        return this.returnNullCopyWhenMdcNotSet;
    }

    public void restoreOptions() {
        this.enable = this.initialEnable;
        this.inherit = this.initialInherit;
        this.returnNullCopyWhenMdcNotSet = this.initialReturnNullCopyWhenMdcNotSet;
        this.allowNullValues = this.initialAllowNullValues;
    }

    public static TestMDCAdapter getInstance() {
        return (TestMDCAdapter)MDC.getMDCAdapter();
    }
}

