/*
 * Decompiled with CFR 0.152.
 */
package io.odin.slf4j;

import cats.Eval$;
import cats.effect.kernel.Sync;
import cats.effect.std.Dispatcher;
import cats.kernel.PartialOrder;
import cats.syntax.package;
import io.odin.Level;
import io.odin.Level$;
import io.odin.Logger;
import io.odin.LoggerMessage$;
import io.odin.meta.Position$;
import io.odin.slf4j.OdinLoggerAdapter$;
import io.odin.slf4j.OdinLoggerVarargsAdapter;
import java.io.Serializable;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class OdinLoggerAdapter<F>
extends MarkerIgnoringBase
implements OdinLoggerVarargsAdapter<F>,
Product {
    private final String loggerName;
    private final Logger underlying;
    private final Sync<F> F;
    private final Dispatcher<F> dispatcher;

    public static <F> OdinLoggerAdapter<F> apply(String string, Logger<F> logger, Sync<F> sync, Dispatcher<F> dispatcher) {
        return OdinLoggerAdapter$.MODULE$.apply(string, logger, sync, dispatcher);
    }

    public static <F> OdinLoggerAdapter<F> unapply(OdinLoggerAdapter<F> odinLoggerAdapter) {
        return OdinLoggerAdapter$.MODULE$.unapply(odinLoggerAdapter);
    }

    public OdinLoggerAdapter(String loggerName, Logger<F> underlying, Sync<F> F, Dispatcher<F> dispatcher) {
        this.loggerName = loggerName;
        this.underlying = underlying;
        this.F = F;
        this.dispatcher = dispatcher;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OdinLoggerAdapter)) return false;
        OdinLoggerAdapter odinLoggerAdapter = (OdinLoggerAdapter)object;
        String string = this.loggerName();
        String string2 = odinLoggerAdapter.loggerName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Logger<F> logger = this.underlying();
        Logger<F> logger2 = odinLoggerAdapter.underlying();
        if (logger == null) {
            if (logger2 != null) {
                return false;
            }
        } else if (!logger.equals(logger2)) return false;
        if (!odinLoggerAdapter.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof OdinLoggerAdapter;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "OdinLoggerAdapter";
    }

    public Object productElement(int n) {
        Logger<F> logger;
        int n2 = n;
        if (0 == n2) {
            logger = this._1();
        } else if (1 == n2) {
            logger = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return logger;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "loggerName";
        } else if (1 == n2) {
            string = "underlying";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public String loggerName() {
        return this.loggerName;
    }

    public Logger<F> underlying() {
        return this.underlying;
    }

    public String getName() {
        return this.loggerName();
    }

    private void run(Level level, String msg, Option<Throwable> t) {
        this.dispatcher.unsafeRunSync(package.all$.MODULE$.toFlatMapOps(this.F.realTime(), this.F).flatMap((Function1 & Serializable)timestamp -> package.all$.MODULE$.toFunctorOps(this.underlying().log(LoggerMessage$.MODULE$.apply(level, Eval$.MODULE$.now((Object)msg), Predef$.MODULE$.Map().empty(), t, Position$.MODULE$.apply(this.loggerName(), this.loggerName(), this.loggerName(), -1), Thread.currentThread().getName(), timestamp.toMillis())), this.F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
        })));
    }

    private Option<Throwable> run$default$3() {
        return None$.MODULE$;
    }

    public void runFormatted(Level level, FormattingTuple tuple) {
        this.run(level, tuple.getMessage(), (Option<Throwable>)Option$.MODULE$.apply((Object)tuple.getThrowable()));
    }

    public boolean isTraceEnabled() {
        return package.all$.MODULE$.catsSyntaxPartialOrder((Object)this.underlying().minLevel(), (PartialOrder)Level$.MODULE$.order()).$less$eq((Object)Level.Trace$.MODULE$);
    }

    public void trace(String msg) {
        this.run((Level)Level.Trace$.MODULE$, msg, this.run$default$3());
    }

    public void trace(String format, Object arg) {
        this.runFormatted((Level)Level.Trace$.MODULE$, MessageFormatter.format((String)format, (Object)arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.runFormatted((Level)Level.Trace$.MODULE$, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void trace(String msg, Throwable t) {
        this.run((Level)Level.Trace$.MODULE$, msg, (Option<Throwable>)Option$.MODULE$.apply((Object)t));
    }

    public boolean isDebugEnabled() {
        return package.all$.MODULE$.catsSyntaxPartialOrder((Object)this.underlying().minLevel(), (PartialOrder)Level$.MODULE$.order()).$less$eq((Object)Level.Debug$.MODULE$);
    }

    public void debug(String msg) {
        this.run((Level)Level.Debug$.MODULE$, msg, this.run$default$3());
    }

    public void debug(String format, Object arg) {
        this.runFormatted((Level)Level.Debug$.MODULE$, MessageFormatter.format((String)format, (Object)arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.runFormatted((Level)Level.Debug$.MODULE$, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void debug(String msg, Throwable t) {
        this.run((Level)Level.Debug$.MODULE$, msg, (Option<Throwable>)Option$.MODULE$.apply((Object)t));
    }

    public boolean isInfoEnabled() {
        return package.all$.MODULE$.catsSyntaxPartialOrder((Object)this.underlying().minLevel(), (PartialOrder)Level$.MODULE$.order()).$less$eq((Object)Level.Info$.MODULE$);
    }

    public void info(String msg) {
        this.run((Level)Level.Info$.MODULE$, msg, this.run$default$3());
    }

    public void info(String format, Object arg) {
        this.runFormatted((Level)Level.Info$.MODULE$, MessageFormatter.format((String)format, (Object)arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.runFormatted((Level)Level.Info$.MODULE$, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void info(String msg, Throwable t) {
        this.run((Level)Level.Info$.MODULE$, msg, (Option<Throwable>)Option$.MODULE$.apply((Object)t));
    }

    public boolean isWarnEnabled() {
        return package.all$.MODULE$.catsSyntaxPartialOrder((Object)this.underlying().minLevel(), (PartialOrder)Level$.MODULE$.order()).$less$eq((Object)Level.Warn$.MODULE$);
    }

    public void warn(String msg) {
        this.run((Level)Level.Warn$.MODULE$, msg, this.run$default$3());
    }

    public void warn(String format, Object arg) {
        this.runFormatted((Level)Level.Warn$.MODULE$, MessageFormatter.format((String)format, (Object)arg));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.runFormatted((Level)Level.Warn$.MODULE$, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void warn(String msg, Throwable t) {
        this.run((Level)Level.Warn$.MODULE$, msg, (Option<Throwable>)Option$.MODULE$.apply((Object)t));
    }

    public boolean isErrorEnabled() {
        return package.all$.MODULE$.catsSyntaxPartialOrder((Object)this.underlying().minLevel(), (PartialOrder)Level$.MODULE$.order()).$less$eq((Object)Level.Error$.MODULE$);
    }

    public void error(String msg) {
        this.run((Level)Level.Error$.MODULE$, msg, this.run$default$3());
    }

    public void error(String format, Object arg) {
        this.runFormatted((Level)Level.Error$.MODULE$, MessageFormatter.format((String)format, (Object)arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.runFormatted((Level)Level.Error$.MODULE$, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void error(String msg, Throwable t) {
        this.run((Level)Level.Error$.MODULE$, msg, (Option<Throwable>)Option$.MODULE$.apply((Object)t));
    }

    public <F> OdinLoggerAdapter<F> copy(String loggerName, Logger<F> underlying, Sync<F> F, Dispatcher<F> dispatcher) {
        return new OdinLoggerAdapter<F>(loggerName, underlying, F, dispatcher);
    }

    public <F> String copy$default$1() {
        return this.loggerName();
    }

    public <F> Logger<F> copy$default$2() {
        return this.underlying();
    }

    public String _1() {
        return this.loggerName();
    }

    public Logger<F> _2() {
        return this.underlying();
    }
}

