/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.Color;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.cell.AbstractCellDrawer;
import org.vandeseer.easytable.settings.BorderStyleInterface;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.TableNotYetBuiltException;

public abstract class AbstractCell {
    private static final float DEFAULT_MIN_HEIGHT = 10.0f;
    private final int colSpan;
    private final int rowSpan;
    protected AbstractCellDrawer drawer;
    private Row row;
    private Column column;
    private float width;
    private float minHeight;
    protected Settings settings;

    public float getPaddingBottom() {
        return this.settings.getPaddingBottom().floatValue();
    }

    public float getPaddingTop() {
        return this.settings.getPaddingTop().floatValue();
    }

    public float getPaddingLeft() {
        return this.settings.getPaddingLeft().floatValue();
    }

    public float getPaddingRight() {
        return this.settings.getPaddingRight().floatValue();
    }

    public float getHorizontalPadding() {
        return this.settings.getPaddingLeft().floatValue() + this.settings.getPaddingRight().floatValue();
    }

    public float getVerticalPadding() {
        return this.settings.getPaddingTop().floatValue() + this.settings.getPaddingBottom().floatValue();
    }

    public float getBorderWidthTop() {
        return this.hasBorderTop() ? this.settings.getBorderWidthTop().floatValue() : 0.0f;
    }

    public boolean hasBorderTop() {
        return this.settings.getBorderWidthTop() != null && this.settings.getBorderWidthTop().floatValue() > 0.0f;
    }

    public float getBorderWidthBottom() {
        return this.hasBorderBottom() ? this.settings.getBorderWidthBottom().floatValue() : 0.0f;
    }

    public boolean hasBorderBottom() {
        return this.settings.getBorderWidthBottom() != null && this.settings.getBorderWidthBottom().floatValue() > 0.0f;
    }

    public float getBorderWidthLeft() {
        return this.hasBorderLeft() ? this.settings.getBorderWidthLeft().floatValue() : 0.0f;
    }

    public boolean hasBorderLeft() {
        return this.settings.getBorderWidthLeft() != null && this.settings.getBorderWidthLeft().floatValue() > 0.0f;
    }

    public float getBorderWidthRight() {
        return this.hasBorderRight() ? this.settings.getBorderWidthRight().floatValue() : 0.0f;
    }

    public boolean hasBorderRight() {
        return this.settings.getBorderWidthRight() != null && this.settings.getBorderWidthRight().floatValue() > 0.0f;
    }

    public Color getBorderColorTop() {
        return this.settings.getBorderColorTop();
    }

    public Color getBorderColorBottom() {
        return this.settings.getBorderColorBottom();
    }

    public Color getBorderColorLeft() {
        return this.settings.getBorderColorLeft();
    }

    public Color getBorderColorRight() {
        return this.settings.getBorderColorRight();
    }

    public BorderStyleInterface getBorderStyleTop() {
        return this.settings.getBorderStyleTop();
    }

    public BorderStyleInterface getBorderStyleBottom() {
        return this.settings.getBorderStyleBottom();
    }

    public BorderStyleInterface getBorderStyleLeft() {
        return this.settings.getBorderStyleLeft();
    }

    public BorderStyleInterface getBorderStyleRight() {
        return this.settings.getBorderStyleRight();
    }

    public boolean hasBackgroundColor() {
        return this.settings.getBackgroundColor() != null;
    }

    public Color getBackgroundColor() {
        return this.settings.getBackgroundColor();
    }

    public boolean isWordBreak() {
        return this.settings.isWordBreak();
    }

    public float getHeight() {
        this.assertIsRendered();
        return this.getRowSpan() > 1 ? this.calculateHeightForRowSpan() : this.getMinHeight();
    }

    public Drawer getDrawer() {
        return this.drawer != null ? this.drawer.withCell(this) : this.createDefaultDrawer();
    }

    protected abstract Drawer createDefaultDrawer();

    public float calculateHeightForRowSpan() {
        Row currentRow = this.row;
        float result = currentRow.getHeight();
        for (int i = 1; i < this.getRowSpan(); ++i) {
            result += currentRow.getNext().getHeight();
            currentRow = currentRow.getNext();
        }
        return result;
    }

    protected void assertIsRendered() {
        if (this.column == null || this.row == null) {
            throw new TableNotYetBuiltException();
        }
    }

    public boolean isHorizontallyAligned(HorizontalAlignment alignment) {
        return this.getSettings().getHorizontalAlignment() == alignment;
    }

    public boolean isVerticallyAligned(VerticalAlignment alignment) {
        return this.getSettings().getVerticalAlignment() == alignment;
    }

    private static int $default$colSpan() {
        return 1;
    }

    private static int $default$rowSpan() {
        return 1;
    }

    private static float $default$minHeight() {
        return 10.0f;
    }

    protected AbstractCell(AbstractCellBuilder<?, ?> b) {
        this.colSpan = b.colSpan$set ? b.colSpan$value : AbstractCell.$default$colSpan();
        this.rowSpan = b.rowSpan$set ? b.rowSpan$value : AbstractCell.$default$rowSpan();
        this.drawer = b.drawer;
        this.row = b.row;
        this.column = b.column;
        this.width = b.width;
        this.minHeight = b.minHeight$set ? b.minHeight$value : AbstractCell.$default$minHeight();
        this.settings = b.settings;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public Row getRow() {
        return this.row;
    }

    public Column getColumn() {
        return this.column;
    }

    public float getWidth() {
        return this.width;
    }

    public float getMinHeight() {
        return this.minHeight;
    }

    public void setDrawer(AbstractCellDrawer drawer) {
        this.drawer = drawer;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected void setSettings(Settings settings) {
        this.settings = settings;
    }

    public static abstract class AbstractCellBuilder<C extends AbstractCell, B extends AbstractCellBuilder<C, B>> {
        private boolean colSpan$set;
        private int colSpan$value;
        private boolean rowSpan$set;
        private int rowSpan$value;
        private AbstractCellDrawer drawer;
        private Row row;
        private Column column;
        private float width;
        private boolean minHeight$set;
        private float minHeight$value;
        protected Settings settings = Settings.builder().build();

        private void settings(Settings settings) {
        }

        public B borderWidth(float borderWidth) {
            this.settings.setBorderWidthTop(Float.valueOf(borderWidth));
            this.settings.setBorderWidthBottom(Float.valueOf(borderWidth));
            this.settings.setBorderWidthLeft(Float.valueOf(borderWidth));
            this.settings.setBorderWidthRight(Float.valueOf(borderWidth));
            return this.self();
        }

        public B borderWidthTop(float borderWidth) {
            this.settings.setBorderWidthTop(Float.valueOf(borderWidth));
            return this.self();
        }

        public B borderWidthBottom(float borderWidth) {
            this.settings.setBorderWidthBottom(Float.valueOf(borderWidth));
            return this.self();
        }

        public B borderWidthLeft(float borderWidth) {
            this.settings.setBorderWidthLeft(Float.valueOf(borderWidth));
            return this.self();
        }

        public B borderWidthRight(float borderWidth) {
            this.settings.setBorderWidthRight(Float.valueOf(borderWidth));
            return this.self();
        }

        public B borderStyleTop(BorderStyleInterface style) {
            this.settings.setBorderStyleTop(style);
            return this.self();
        }

        public B borderStyleBottom(BorderStyleInterface style) {
            this.settings.setBorderStyleBottom(style);
            return this.self();
        }

        public B borderStyleLeft(BorderStyleInterface style) {
            this.settings.setBorderStyleLeft(style);
            return this.self();
        }

        public B borderStyleRight(BorderStyleInterface style) {
            this.settings.setBorderStyleRight(style);
            return this.self();
        }

        public B borderStyle(BorderStyleInterface style) {
            return ((AbstractCellBuilder)((AbstractCellBuilder)((AbstractCellBuilder)this.borderStyleLeft(style)).borderStyleRight(style)).borderStyleBottom(style)).borderStyleTop(style);
        }

        public B padding(float padding) {
            return ((AbstractCellBuilder)((AbstractCellBuilder)((AbstractCellBuilder)this.paddingTop(padding)).paddingBottom(padding)).paddingLeft(padding)).paddingRight(padding);
        }

        public B paddingTop(float padding) {
            this.settings.setPaddingTop(Float.valueOf(padding));
            return this.self();
        }

        public B paddingBottom(float padding) {
            this.settings.setPaddingBottom(Float.valueOf(padding));
            return this.self();
        }

        public B paddingLeft(float padding) {
            this.settings.setPaddingLeft(Float.valueOf(padding));
            return this.self();
        }

        public B paddingRight(float padding) {
            this.settings.setPaddingRight(Float.valueOf(padding));
            return this.self();
        }

        public B horizontalAlignment(HorizontalAlignment alignment) {
            this.settings.setHorizontalAlignment(alignment);
            return this.self();
        }

        public B verticalAlignment(VerticalAlignment alignment) {
            this.settings.setVerticalAlignment(alignment);
            return this.self();
        }

        public B backgroundColor(Color backgroundColor) {
            this.settings.setBackgroundColor(backgroundColor);
            return this.self();
        }

        public B borderColorTop(Color borderColor) {
            this.settings.setBorderColorTop(borderColor);
            return this.self();
        }

        public B borderColorBottom(Color borderColor) {
            this.settings.setBorderColorBottom(borderColor);
            return this.self();
        }

        public B borderColorLeft(Color borderColor) {
            this.settings.setBorderColorLeft(borderColor);
            return this.self();
        }

        public B borderColorRight(Color borderColor) {
            this.settings.setBorderColorRight(borderColor);
            return this.self();
        }

        public B borderColor(Color borderColor) {
            ((AbstractCellBuilder)((AbstractCellBuilder)((AbstractCellBuilder)this.borderColorBottom(borderColor)).borderColorTop(borderColor)).borderColorLeft(borderColor)).borderColorRight(borderColor);
            return this.self();
        }

        public B wordBreak(Boolean wordBreak) {
            this.settings.setWordBreak(wordBreak);
            return this.self();
        }

        protected B $fillValuesFrom(C instance) {
            AbstractCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AbstractCell instance, AbstractCellBuilder<?, ?> b) {
            b.colSpan(instance.colSpan);
            b.rowSpan(instance.rowSpan);
            b.drawer(instance.drawer);
            b.row(instance.row);
            b.column(instance.column);
            b.width(instance.width);
            b.minHeight(instance.minHeight);
            b.settings(instance.settings);
        }

        public B colSpan(int colSpan) {
            this.colSpan$value = colSpan;
            this.colSpan$set = true;
            return this.self();
        }

        public B rowSpan(int rowSpan) {
            this.rowSpan$value = rowSpan;
            this.rowSpan$set = true;
            return this.self();
        }

        public B drawer(AbstractCellDrawer drawer) {
            this.drawer = drawer;
            return this.self();
        }

        public B row(Row row) {
            this.row = row;
            return this.self();
        }

        public B column(Column column) {
            this.column = column;
            return this.self();
        }

        public B width(float width) {
            this.width = width;
            return this.self();
        }

        public B minHeight(float minHeight) {
            this.minHeight$value = minHeight;
            this.minHeight$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractCell.AbstractCellBuilder(colSpan$value=" + this.colSpan$value + ", rowSpan$value=" + this.rowSpan$value + ", drawer=" + this.drawer + ", row=" + this.row + ", column=" + this.column + ", width=" + this.width + ", minHeight$value=" + this.minHeight$value + ", settings=" + this.settings + ")";
        }
    }
}

