/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.vandeseer.easytable.settings.BorderStyleInterface;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Table;

public class Column {
    private Table table;
    private Column next;
    private float width;
    private Settings settings;

    Column(float width) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("Column width must be non-negative");
        }
        this.width = width;
        this.settings = Settings.builder().build();
    }

    private Column(float width, Settings settings) {
        this(width);
        this.settings = settings;
    }

    public static ColumnBuilder builder() {
        return new ColumnBuilder();
    }

    boolean hasNext() {
        return this.next != null;
    }

    public Table getTable() {
        return this.table;
    }

    public Column getNext() {
        return this.next;
    }

    public float getWidth() {
        return this.width;
    }

    public Settings getSettings() {
        return this.settings;
    }

    void setTable(Table table) {
        this.table = table;
    }

    void setNext(Column next) {
        this.next = next;
    }

    void setWidth(float width) {
        this.width = width;
    }

    public static class ColumnBuilder {
        private float width;
        private Settings settings = Settings.builder().build();

        ColumnBuilder() {
        }

        public ColumnBuilder width(float width) {
            this.width = width;
            return this;
        }

        private ColumnBuilder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public ColumnBuilder font(PDFont font) {
            this.settings.setFont(font);
            return this;
        }

        public ColumnBuilder font(Standard14Fonts.FontName fontName) {
            this.settings.setFont((PDFont)new PDType1Font(fontName));
            return this;
        }

        public ColumnBuilder fontSize(Integer fontSize) {
            this.settings.setFontSize(fontSize);
            return this;
        }

        public ColumnBuilder textColor(Color textColor) {
            this.settings.setTextColor(textColor);
            return this;
        }

        public ColumnBuilder backgroundColor(Color backgroundColor) {
            this.settings.setBackgroundColor(backgroundColor);
            return this;
        }

        public ColumnBuilder padding(float padding) {
            this.settings.setPaddingTop(Float.valueOf(padding));
            this.settings.setPaddingBottom(Float.valueOf(padding));
            this.settings.setPaddingLeft(Float.valueOf(padding));
            this.settings.setPaddingRight(Float.valueOf(padding));
            return this;
        }

        public ColumnBuilder borderWidth(float borderWidth) {
            this.settings.setBorderWidthLeft(Float.valueOf(borderWidth));
            this.settings.setBorderWidthRight(Float.valueOf(borderWidth));
            this.settings.setBorderWidthTop(Float.valueOf(borderWidth));
            this.settings.setBorderWidthBottom(Float.valueOf(borderWidth));
            return this;
        }

        public ColumnBuilder borderWidthLeft(float borderWidth) {
            this.settings.setBorderWidthLeft(Float.valueOf(borderWidth));
            return this;
        }

        public ColumnBuilder borderWidthRight(float borderWidth) {
            this.settings.setBorderWidthRight(Float.valueOf(borderWidth));
            return this;
        }

        public ColumnBuilder borderStyleLeft(BorderStyleInterface borderStyle) {
            this.settings.setBorderStyleLeft(borderStyle);
            return this;
        }

        public ColumnBuilder borderStyleRight(BorderStyleInterface borderStyle) {
            this.settings.setBorderStyleRight(borderStyle);
            return this;
        }

        public ColumnBuilder borderColorLeft(Color borderColor) {
            this.settings.setBorderColorLeft(borderColor);
            return this;
        }

        public ColumnBuilder borderColorRight(Color borderColor) {
            this.settings.setBorderColorRight(borderColor);
            return this;
        }

        public ColumnBuilder horizontalAlignment(HorizontalAlignment alignment) {
            this.settings.setHorizontalAlignment(alignment);
            return this;
        }

        public ColumnBuilder verticalAlignment(VerticalAlignment alignment) {
            this.settings.setVerticalAlignment(alignment);
            return this;
        }

        public ColumnBuilder wordBreak(Boolean wordBreak) {
            this.settings.setWordBreak(wordBreak);
            return this;
        }

        public Column build() {
            return new Column(this.width, this.settings);
        }
    }
}

