/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedLine;
import org.vandeseer.easytable.drawing.PositionedRectangle;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.util.FloatUtil;

public abstract class AbstractCellDrawer<T extends AbstractCell>
implements Drawer {
    protected T cell;

    public AbstractCellDrawer<T> withCell(T cell) {
        this.cell = cell;
        return this;
    }

    @Override
    public void drawBackground(DrawingContext drawingContext) {
        if (((AbstractCell)this.cell).hasBackgroundColor()) {
            PDPageContentStream contentStream = drawingContext.getContentStream();
            Point2D.Float start = drawingContext.getStartingPoint();
            float rowHeight = ((AbstractCell)this.cell).getRow().getHeight();
            float height = Math.max(((AbstractCell)this.cell).getHeight(), rowHeight);
            float y = rowHeight < ((AbstractCell)this.cell).getHeight() ? start.y + rowHeight - ((AbstractCell)this.cell).getHeight() : start.y;
            DrawingUtil.drawRectangle(contentStream, PositionedRectangle.builder().x(start.x).y(y).width(((AbstractCell)this.cell).getWidth()).height(height).color(((AbstractCell)this.cell).getBackgroundColor()).build());
        }
    }

    @Override
    public abstract void drawContent(DrawingContext var1);

    @Override
    public void drawBorders(DrawingContext drawingContext) {
        Point2D.Float start = drawingContext.getStartingPoint();
        PDPageContentStream contentStream = drawingContext.getContentStream();
        float cellWidth = ((AbstractCell)this.cell).getWidth();
        float rowHeight = ((AbstractCell)this.cell).getRow().getHeight();
        float height = Math.max(((AbstractCell)this.cell).getHeight(), rowHeight);
        float sY = rowHeight < ((AbstractCell)this.cell).getHeight() ? start.y + rowHeight - ((AbstractCell)this.cell).getHeight() : start.y;
        Color cellBorderColorTop = ((AbstractCell)this.cell).getBorderColorTop();
        Color cellBorderColorBottom = ((AbstractCell)this.cell).getBorderColorBottom();
        Color cellBorderColorLeft = ((AbstractCell)this.cell).getBorderColorLeft();
        Color cellBorderColorRight = ((AbstractCell)this.cell).getBorderColorRight();
        Color rowBorderColor = ((AbstractCell)this.cell).getRow().getBorderColor();
        if (((AbstractCell)this.cell).hasBorderTop() || ((AbstractCell)this.cell).hasBorderBottom()) {
            float correctionLeft = ((AbstractCell)this.cell).getBorderWidthLeft() / 2.0f;
            float correctionRight = ((AbstractCell)this.cell).getBorderWidthRight() / 2.0f;
            if (((AbstractCell)this.cell).hasBorderTop()) {
                DrawingUtil.drawLine(contentStream, PositionedLine.builder().startX(start.x - correctionLeft).startY(start.y + rowHeight).endX(start.x + cellWidth + correctionRight).endY(start.y + rowHeight).width(((AbstractCell)this.cell).getBorderWidthTop()).color(cellBorderColorTop).resetColor(rowBorderColor).borderStyle(((AbstractCell)this.cell).getBorderStyleTop()).build());
            }
            if (((AbstractCell)this.cell).hasBorderBottom()) {
                DrawingUtil.drawLine(contentStream, PositionedLine.builder().startX(start.x - correctionLeft).startY(sY).endX(start.x + cellWidth + correctionRight).endY(sY).width(((AbstractCell)this.cell).getBorderWidthBottom()).color(cellBorderColorBottom).resetColor(rowBorderColor).borderStyle(((AbstractCell)this.cell).getBorderStyleBottom()).build());
            }
        }
        if (((AbstractCell)this.cell).hasBorderLeft() || ((AbstractCell)this.cell).hasBorderRight()) {
            float correctionTop = ((AbstractCell)this.cell).getBorderWidthTop() / 2.0f;
            float correctionBottom = ((AbstractCell)this.cell).getBorderWidthBottom() / 2.0f;
            if (((AbstractCell)this.cell).hasBorderLeft()) {
                DrawingUtil.drawLine(contentStream, PositionedLine.builder().startX(start.x).startY(sY - correctionBottom).endX(start.x).endY(sY + height + correctionTop).width(((AbstractCell)this.cell).getBorderWidthLeft()).color(cellBorderColorLeft).resetColor(rowBorderColor).borderStyle(((AbstractCell)this.cell).getBorderStyleLeft()).build());
            }
            if (((AbstractCell)this.cell).hasBorderRight()) {
                DrawingUtil.drawLine(contentStream, PositionedLine.builder().startX(start.x + cellWidth).startY(sY - correctionBottom).endX(start.x + cellWidth).endY(sY + height + correctionTop).width(((AbstractCell)this.cell).getBorderWidthRight()).color(cellBorderColorRight).resetColor(rowBorderColor).borderStyle(((AbstractCell)this.cell).getBorderStyleRight()).build());
            }
        }
    }

    protected boolean rowHeightIsBiggerThanOrEqualToCellHeight() {
        return ((AbstractCell)this.cell).getRow().getHeight() > ((AbstractCell)this.cell).getHeight() || FloatUtil.isEqualInEpsilon(((AbstractCell)this.cell).getRow().getHeight(), ((AbstractCell)this.cell).getHeight());
    }

    protected float getRowSpanAdaption() {
        return ((AbstractCell)this.cell).getRowSpan() > 1 ? ((AbstractCell)this.cell).calculateHeightForRowSpan() - ((AbstractCell)this.cell).getRow().getHeight() : 0.0f;
    }

    protected float calculateOuterHeight() {
        return ((AbstractCell)this.cell).getRowSpan() > 1 ? ((AbstractCell)this.cell).getHeight() : ((AbstractCell)this.cell).getRow().getHeight();
    }

    protected float getAdaptionForVerticalAlignment() {
        if (this.rowHeightIsBiggerThanOrEqualToCellHeight() || ((AbstractCell)this.cell).getRowSpan() > 1) {
            if (((AbstractCell)this.cell).isVerticallyAligned(VerticalAlignment.MIDDLE)) {
                return this.calculateOuterHeight() / 2.0f + this.calculateInnerHeight() / 2.0f - this.getRowSpanAdaption();
            }
            if (((AbstractCell)this.cell).isVerticallyAligned(VerticalAlignment.BOTTOM)) {
                return this.calculateInnerHeight() + ((AbstractCell)this.cell).getPaddingBottom() - this.getRowSpanAdaption();
            }
        }
        return ((AbstractCell)this.cell).getRow().getHeight() - ((AbstractCell)this.cell).getPaddingTop();
    }

    protected abstract float calculateInnerHeight();
}

