/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.util.FloatUtil;

public final class PdfUtil {
    public static final String NEW_LINE_REGEX = "\\r?\\n";

    public static float getStringWidth(String text, PDFont font, int fontSize) {
        return Arrays.stream(text.split(NEW_LINE_REGEX)).max(Comparator.comparing(String::length)).map(x -> Float.valueOf(PdfUtil.getWidthOfStringWithoutNewlines(x, font, fontSize))).orElseThrow(CouldNotDetermineStringWidthException::new).floatValue();
    }

    private static float getWidthOfStringWithoutNewlines(String text, PDFont font, int fontSize) {
        List codePointsAsString = text.codePoints().mapToObj(codePoint -> new String(new int[]{codePoint}, 0, 1)).collect(Collectors.toList());
        ArrayList<Float> widths = new ArrayList<Float>();
        for (String codepoint : codePointsAsString) {
            try {
                widths.add(Float.valueOf(font.getStringWidth(codepoint) * (float)fontSize / 1000.0f));
            }
            catch (IllegalArgumentException e) {
                widths.add(Float.valueOf(font.getStringWidth("\u2013") * (float)fontSize / 1000.0f));
            }
        }
        return widths.stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public static float getFontHeight(PDFont font, int fontSize) {
        return font.getFontDescriptor().getCapHeight() * (float)fontSize / 1000.0f;
    }

    public static List<String> getOptimalTextBreakLines(String text, PDFont font, int fontSize, float maxWidth) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : text.split(NEW_LINE_REGEX)) {
            if (PdfUtil.doesTextLineFit(line, font, fontSize, maxWidth)) {
                result.add(line);
                continue;
            }
            result.addAll(PdfUtil.wrapLine(line, font, fontSize, maxWidth));
        }
        return result;
    }

    private static List<String> wrapLine(String line, PDFont font, int fontSize, float maxWidth) {
        if (PdfUtil.doesTextLineFit(line, font, fontSize, maxWidth)) {
            return Collections.singletonList(line);
        }
        ArrayList<String> goodLines = new ArrayList<String>();
        Stack<String> allWords = new Stack<String>();
        Arrays.asList(line.split("(?<=[\\\\. ,-])")).forEach(allWords::push);
        Collections.reverse(allWords);
        while (!allWords.empty()) {
            goodLines.add(PdfUtil.buildALine(allWords, font, fontSize, maxWidth));
        }
        return goodLines;
    }

    private static List<String> splitBySize(String line, PDFont font, int fontSize, float maxWidth) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = line.length() - 1; i > 0; --i) {
            String fittedNewLine = line.substring(0, i) + "-";
            String remains = line.substring(i);
            if (!PdfUtil.doesTextLineFit(fittedNewLine, font, fontSize, maxWidth)) continue;
            returnList.add(fittedNewLine);
            returnList.addAll(PdfUtil.wrapLine(remains, font, fontSize, maxWidth));
            break;
        }
        return returnList;
    }

    private static String buildALine(Stack<String> words, PDFont font, int fontSize, float maxWidth) {
        StringBuilder line = new StringBuilder();
        float width = 0.0f;
        while (!words.empty()) {
            float nextWordWidth = PdfUtil.getStringWidth(words.peek(), font, fontSize);
            if (line.length() == 0 && words.peek().length() == 1 && nextWordWidth > maxWidth) {
                return words.pop();
            }
            if (!PdfUtil.doesTextLineFit(width + nextWordWidth, maxWidth)) break;
            line.append(words.pop());
            width += nextWordWidth;
        }
        if (width == 0.0f && !words.empty()) {
            List<String> cutBySize = PdfUtil.splitBySize(words.pop(), font, fontSize, maxWidth);
            Collections.reverse(cutBySize);
            cutBySize.forEach(words::push);
            return PdfUtil.buildALine(words, font, fontSize, maxWidth);
        }
        return line.toString().trim();
    }

    private static boolean doesTextLineFit(String textLine, PDFont font, int fontSize, float maxWidth) {
        return PdfUtil.doesTextLineFit(PdfUtil.getStringWidth(textLine, font, fontSize), maxWidth);
    }

    private static boolean doesTextLineFit(float stringWidth, float maxWidth) {
        if (FloatUtil.isEqualInEpsilon(stringWidth, maxWidth)) {
            return true;
        }
        return maxWidth > stringWidth;
    }

    private PdfUtil() {
    }

    private static class CouldNotDetermineStringWidthException
    extends RuntimeException {
        CouldNotDetermineStringWidthException() {
        }
    }
}

